/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.query.impl;

import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.member.api.common.condition.Criteria;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponTemplateExtQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.query.ICouponAnonymousQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.BeanCopyUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.coupon.das.CouponAnonymousDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.CouponAnonymousEo;
import com.github.pagehelper.PageInfo;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CouponAnonymousQueryServiceImpl
implements ICouponAnonymousQueryService {
    @Autowired
    private CouponAnonymousDas couponAnonymousDas;
    @Autowired
    private ICouponTemplateExtQueryService couponTemplateExtQueryService;
    private static final Logger logger = LoggerFactory.getLogger(CouponAnonymousQueryServiceImpl.class);

    @Override
    public PageInfo<CouponExtRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        List eoList;
        Criteria criteria;
        PageInfo responseInfo = new PageInfo();
        try {
            criteria = (Criteria)ObjectHelper.Json2Bean((String)filter, Criteria.class);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new RuntimeException();
        }
        CouponAnonymousEo query = CouponAnonymousEo.newInstance();
        if (null != criteria) {
            query.setSqlFilters(criteria.getFilters());
        }
        if (null != pageNum && pageSize != null) {
            PageInfo pageInfo = this.couponAnonymousDas.selectPage((BaseEo)query, pageNum, pageSize);
            BeanUtils.copyProperties((Object)pageInfo, (Object)responseInfo);
            eoList = pageInfo.getList();
        } else {
            eoList = this.couponAnonymousDas.select((BaseEo)query);
        }
        List<CouponExtRespDto> dtoList = BeanCopyUtil.copyCollections(eoList, CouponExtRespDto.class, new String[0]);
        dtoList.forEach(dto -> dto.setCouponStatusDescription(CouponStatusEnum.getByStatus((String)dto.getCouponStatus()).getDescription()));
        responseInfo.setList(dtoList);
        return responseInfo;
    }

    @Override
    public CouponExtRespDto queryById(Long id) {
        if (id == null) {
            return null;
        }
        CouponAnonymousEo couponEo = (CouponAnonymousEo)this.couponAnonymousDas.selectByPrimaryKey(id);
        CouponExtRespDto couponExtRespDto = this.eo2Dto(couponEo);
        if (null != couponExtRespDto) {
            CouponTemplateExtRespDto couponTemplateExtRespDto = this.couponTemplateExtQueryService.queryById(couponExtRespDto.getCouponTemplateId());
            couponExtRespDto.setCouponTemplate(couponTemplateExtRespDto);
        }
        return couponExtRespDto;
    }

    @Override
    public CouponExtRespDto queryByCode(String couponCode) {
        if (StringUtils.isBlank((CharSequence)couponCode)) {
            return null;
        }
        CouponAnonymousEo couponEo = new CouponAnonymousEo();
        couponEo.setCouponCode(couponCode);
        couponEo = (CouponAnonymousEo)this.couponAnonymousDas.selectOne((BaseEo)couponEo);
        CouponExtRespDto couponExtRespDto = this.eo2Dto(couponEo);
        if (null != couponExtRespDto) {
            CouponTemplateExtRespDto couponTemplateExtRespDto = this.couponTemplateExtQueryService.queryById(couponExtRespDto.getCouponTemplateId());
            couponExtRespDto.setCouponTemplate(couponTemplateExtRespDto);
        }
        return couponExtRespDto;
    }

    @Override
    public CouponExtRespDto eo2Dto(CouponAnonymousEo couponEo) {
        return null != couponEo ? BeanCopyUtil.copyProperties(CouponExtRespDto.class, couponEo, new String[0]) : null;
    }

    @Override
    public List<CouponExtRespDto> eoList2DtoList(List<CouponAnonymousEo> list) {
        return CollectionUtils.isEmpty(list) ? Collections.emptyList() : BeanCopyUtil.copyCollections(list, CouponExtRespDto.class, new String[0]);
    }

    @Override
    public List<CouponExtRespDto> listByUserId(Long memberId, String couponStatus) {
        if (memberId == null || memberId == 0L) {
            return Collections.emptyList();
        }
        CouponAnonymousEo query = CouponAnonymousEo.newInstance();
        query.setUserId(memberId);
        query.setCouponStatus(couponStatus);
        List list = this.couponAnonymousDas.select((BaseEo)query);
        return BeanCopyUtil.copyCollections(list, CouponExtRespDto.class, new String[0]);
    }
}

