/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.action;

import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityUserMappingQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActionTemplateRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.EnableStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityUserMappingService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.coupon.service.ICouponService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.coupon.service.ICouponTemplateService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ActionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.CouponTemplateEo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class DeliveryCouponAction
extends ActionTemplate {
    @Resource
    private ICouponService couponService;
    @Resource
    private IActivityUserMappingService activityUserMappingService;
    @Resource
    private ICouponTemplateService couponTemplateService;
    private static final String DELIVERY_NUM = "deliveryCoupon.num";
    private static final String DELIVERY_VALID_ADD_TIME = "deliveryCoupon.validAddTime";

    @Override
    public <T extends EngineParams> boolean execute(ActionTemplateRespDto actionTemplateDto, ActionRespDto actionDto, T params, Map<String, ?> activityParams) {
        Long couponTemplateId = params.getCouponTemplateId();
        ActivityUserMappingQueryReqDto activityUserMappingQueryReqDto = new ActivityUserMappingQueryReqDto();
        activityUserMappingQueryReqDto.setUserId(Long.valueOf(params.getUserId()));
        activityUserMappingQueryReqDto.setActivityId(Long.valueOf(params.getActivityId()));
        int activityUserCount = this.activityUserMappingService.countActivityUserMapping(activityUserMappingQueryReqDto);
        if (activityUserCount <= 0) {
            throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u8a72\u7528\u6236\u4e0d\u5728\u6d3b\u52d5\u7684\u7528\u6236\u5217\u8868\u4e2d"}));
        }
        CouponTemplateEo couponTemplateEo = this.couponTemplateService.getCouponTemplateById(couponTemplateId);
        if (null == couponTemplateEo) {
            throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u8981\u53d1\u7684\u4f18\u60e0\u5238\u4e0d\u5b58\u5728"}));
        }
        if (EnableStatusEnum.DISABLE.getKey().equals(couponTemplateEo.getStatus())) {
            throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u4f18\u60e0\u5238\u5df2\u4e0d\u53ef\u53d1\u653e"}));
        }
        Date couponEffectiveTime = null;
        Date couponInvalidTime = null;
        Integer addDay = (Integer)activityParams.get(DELIVERY_VALID_ADD_TIME);
        if (addDay == null) {
            String couponEffectiveTimeStr = (String)params.getExtendsAttribute().get("couponEffectiveTime");
            String couponInvalidTimeStr = (String)params.getExtendsAttribute().get("couponInvalidTime");
            if (couponEffectiveTimeStr != null) {
                couponEffectiveTime = DateUtil.parseDate((String)couponEffectiveTimeStr, (String)"yyyy-MM-dd hh:mm:ss");
                Assert.notNull((Object)couponEffectiveTime, (String)"\u751f\u6548\u65f6\u95f4\u65e5\u671f\u4e0d\u5bf9");
            }
            if (couponInvalidTimeStr != null) {
                couponInvalidTime = DateUtil.parseDate((String)couponInvalidTimeStr, (String)"yyyy-MM-dd hh:mm:ss");
                Assert.notNull((Object)couponInvalidTime, (String)"\u5931\u6548\u65f6\u95f4\u65e5\u671f\u4e0d\u5bf9");
            }
        } else {
            couponEffectiveTime = DateUtil.getDayBegin();
            couponInvalidTime = DateUtil.addDays((Date)couponEffectiveTime, (int)addDay);
        }
        Integer num = (Integer)activityParams.get(DELIVERY_NUM);
        ArrayList<Long> coupons = new ArrayList<Long>();
        for (int i = 0; i < num; ++i) {
            coupons.addAll(this.couponService.receiveCoupons(Lists.newArrayList((Object[])new Long[]{couponTemplateId}), params.getUserId(), couponEffectiveTime, couponInvalidTime));
        }
        if (!CollectionUtils.isEmpty(coupons)) {
            params.getExtendsAttribute().put("response", coupons);
            return true;
        }
        throw new ProBizException(ProExceptionCode.UNKNOWN_ERR);
    }
}

