/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore;

import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.ProportionUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore.AbstractConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore.enums.DiscountType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore.enums.PromotionCategory;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore.enums.Stair;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore.vo.MoneyOffConditionVo;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

public class MoneyOffExtCondition
extends AbstractConditionTemplate<MoneyOffConditionVo> {
    private static final String CONDITION = "MoneyOffExtCondition.condition";
    private static final String TYPE = "MoneyOffExtCondition.type";

    @Override
    public <T extends EngineParams> boolean execute(TemplateDefine templateDefine, ConditionRespDto conditionRespDto, T context, Map<String, ?> configParams) {
        Integer discountTypeInt = (Integer)this.getParam(TYPE, templateDefine, configParams, "\u6298\u6263\u7c7b\u578b\u672a\u914d\u7f6e");
        DiscountType discountType = DiscountType.getByType(discountTypeInt);
        List conditionVos = this.sort((List)this.getParam(CONDITION, templateDefine, configParams, "\u6298\u6263\u6761\u4ef6\u672a\u914d\u7f6e"));
        BigDecimal itemTotalAmt = this.getItemTotalAmt(context.getItems());
        Integer itemTotalNum = this.getItemTotalNum(context.getItems());
        Stair stair = Stair.newStair();
        boolean result = false;
        for (MoneyOffConditionVo condition : conditionVos) {
            PromotionCategory promotionCategory = PromotionCategory.getByType(condition.getCondition());
            if (promotionCategory == null) {
                throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u4fc3\u9500\u7c7b\u522b\u672a\u914d\u7f6e"}));
            }
            result |= this.switchPromotionCategory(promotionCategory, stair, context, itemTotalAmt, itemTotalNum, discountType, condition);
        }
        if (!result) {
            throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u4e0d\u6ee1\u8db3\u53c2\u4e0e\u6d3b\u52a8\u6761\u4ef6"}));
        }
        return result;
    }

    @Override
    public <T extends EngineParams> boolean eachFull(T context, BigDecimal itemTotalAmt, Integer itemTotalNum, DiscountType discountType, MoneyOffConditionVo conditionVo) {
        int discountCount;
        if (discountType.getType().equals(DiscountType.FULL_FOLD.getType())) {
            throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u6ee1\u6298\u4e0d\u80fd\u542b\u6709\"\u6bcf\u6ee1\"\u6761\u4ef6"}));
        }
        if (itemTotalAmt.compareTo(BigDecimal.ZERO) > 0 && conditionVo.getLimitAmount().compareTo(BigDecimal.ZERO) > 0 && (discountCount = itemTotalAmt.divide(conditionVo.getLimitAmount(), 0, 1).intValue()) > 0) {
            BigDecimal disCountValue = conditionVo.getDiscountValue().multiply(new BigDecimal(discountCount));
            conditionVo.setDiscountValue(disCountValue);
            this.handleDiscount(context, itemTotalAmt, discountType, conditionVo);
            return true;
        }
        return false;
    }

    @Override
    public <T extends EngineParams> boolean equal(T context, BigDecimal itemTotalAmt, Integer itemTotalNum, DiscountType discountType, MoneyOffConditionVo conditionVo) {
        if (discountType.getType().equals(DiscountType.FULL_FOLD.getType())) {
            throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u6ee1\u6298\u4e0d\u80fd\u542b\u6709\"\u7b49\u4e8e\"\u6761\u4ef6"}));
        }
        return super.equal(context, itemTotalAmt, itemTotalNum, discountType, conditionVo);
    }

    @Override
    public <T extends EngineParams> void handleDiscount(T context, BigDecimal itemTotalAmt, DiscountType discountType, MoneyOffConditionVo conditionVo) {
        BigDecimal distinctPrice;
        switch (discountType) {
            case FULL_FOLD: {
                BigDecimal foldPrice = itemTotalAmt.multiply(conditionVo.getDiscountValue()).divide(new BigDecimal(100), context.getScale(), context.getRoundModel());
                distinctPrice = ProportionUtil.avgDisCounts(context.getItems(), foldPrice, context.getScale(), context.getRoundModel());
                break;
            }
            case FULL_REDUCTION: {
                distinctPrice = ProportionUtil.avgDisCounts(context.getItems(), conditionVo.getDiscountValue(), context.getScale(), context.getRoundModel());
                break;
            }
            default: {
                throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u6298\u6263\u7c7b\u578b\u6709\u8bef"}));
            }
        }
        context.setTotalDiscountAmount(context.getTotalDiscountAmount().add(distinctPrice));
    }
}

