/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.converter.promotion.condition;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ConditionTemplateType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ItemsRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service.query.ICouponTemplateExtQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service.query.IItemsQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.ConditionDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.PromotionDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.PromotionPointInfoDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.PromotionRulesPointDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.response.PointExchangeConfigRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.response.PromotionInfoRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.utils.MapUtils;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.converter.promotion.condition.AbstractBaseTemplate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.util.StringUtils;

public class PointExchangeCondition
extends AbstractBaseTemplate {
    @Override
    public boolean support(ActivityType type) {
        return ActivityType.INTEGRAL_EXCHANGE_ACTIVITY.equals((Object)type);
    }

    @Override
    public long getConditionTemplateId() {
        return ConditionTemplateType.POINT_EXCHANGE.getId();
    }

    @Override
    public long getRuleId() {
        return 1196945569812278404L;
    }

    @Override
    public Map<String, Object> processRule(PromotionDto dto) {
        HashMap<String, Object> param = new HashMap<String, Object>(3);
        PromotionPointInfoDto info = (PromotionPointInfoDto)dto;
        param.put("PointExchangeCondition.type", info.getType());
        param.put("PointExchangeCondition.dayLimit", info.getJoinMax());
        ArrayList mapList = new ArrayList(4);
        for (PromotionRulesPointDto rulesPointDto : info.getRulesPointDtos()) {
            HashMap<String, Object> temp = new HashMap<String, Object>(4);
            temp.put("objCode", rulesPointDto.getObjCode());
            temp.put("objId", rulesPointDto.getObjId());
            temp.put("salePrice", rulesPointDto.getSalesPrice());
            temp.put("points", rulesPointDto.getPoint());
            temp.put("price", rulesPointDto.getPrice());
            mapList.add(temp);
        }
        param.put("PointExchangeCondition.condition", mapList);
        return param;
    }

    @Override
    public List<ConditionDto> changeToRules(ConditionRespDto conditionRespDto, PromotionInfoRespDto resp) {
        ArrayList ruleList = Lists.newArrayList();
        JSONObject conditionObj = JSON.parseObject((String)conditionRespDto.getConditionParams());
        List conditionArr = JSON.parseArray((String)conditionObj.getString("PointExchangeCondition.condition"), JSONObject.class);
        if (CollectionUtils.isNotEmpty((Collection)conditionArr)) {
            Integer type = conditionObj.getInteger("PointExchangeCondition.type");
            Integer dayLimit = conditionObj.getInteger("PointExchangeCondition.dayLimit");
            PointExchangeConfigRespDto pointExchangeConfigRespDto = new PointExchangeConfigRespDto();
            pointExchangeConfigRespDto.setType(type.intValue());
            pointExchangeConfigRespDto.setJoinMax(dayLimit.intValue());
            resp.setPointExchangeConfigRespDto(pointExchangeConfigRespDto);
            conditionArr.forEach(condition -> {
                PromotionRulesPointDto rulesDto = new PromotionRulesPointDto();
                String objCode = MapUtils.getString((Map)condition, (Object)"objCode");
                rulesDto.setObjCode(objCode);
                rulesDto.setObjId(MapUtils.getLong((Map)condition, (Object)"objId"));
                rulesDto.setSalesPrice(MapUtils.getBigDecimal((Map)condition, (Object)"salePrice"));
                rulesDto.setPoint(MapUtils.getIntValue((Map)condition, (Object)"points"));
                rulesDto.setPrice(MapUtils.getBigDecimal((Map)condition, (Object)"price"));
                if (!StringUtils.isEmpty((Object)objCode)) {
                    CouponTemplateExtRespDto coupon;
                    if (Objects.equals(type, 1)) {
                        ItemsRespDto item = (ItemsRespDto)((IItemsQueryApi)SpringBeanUtil.getBean(IItemsQueryApi.class)).queryByCode(objCode).getData();
                        if (item != null) {
                            rulesDto.setObjName(item.getName());
                            rulesDto.setObjCode(item.getCode());
                            rulesDto.setObjDesc(item.getCategoryDesc());
                        }
                    } else if (Objects.equals(type, 2) && (coupon = (CouponTemplateExtRespDto)((ICouponTemplateExtQueryApi)SpringBeanUtil.getBean(ICouponTemplateExtQueryApi.class)).queryByCodeSimple(objCode).getData()) != null) {
                        rulesDto.setObjName(coupon.getCouponName());
                        rulesDto.setObjCode(coupon.getCouponCode());
                        rulesDto.setObjDesc(coupon.getRemark());
                        rulesDto.setObjType(coupon.getCouponType());
                    }
                }
                ruleList.add(rulesDto);
            });
        }
        return ruleList;
    }
}

