/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.schedule;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.yundt.cube.biz.member.api.rule.enums.RuleGroupStatusEnum;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service.query.ICouponExtQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.TriggerTimeTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponEventService;
import com.dtyunxi.yundt.imkt.bundle.eventpool.center.member.api.dto.request.EventRuleQueryReqDto;
import com.dtyunxi.yundt.imkt.bundle.eventpool.center.member.api.enums.EventTriggerModeEnum;
import com.dtyunxi.yundt.imkt.bundle.eventpool.center.member.api.query.IEventRuleQueryApi;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="couponExpireBeforeSchedule")
@Scope(value="prototype")
public class CouponExpireBeforeSchedule
extends SingleTupleScheduleEvent {
    private static final Logger logger = LoggerFactory.getLogger(CouponExpireBeforeSchedule.class);
    @Resource
    private ICouponEventService couponEventService;
    @Resource
    private ICouponExtQueryApi couponExtQueryApi;
    @Resource
    private IEventRuleQueryApi eventRuleQueryApi;

    public void before(TaskMsg taskMsg) {
    }

    public boolean execute(TaskMsg taskMsg) {
        logger.info("\u5b9a\u65f6\u67e5\u8be2\u8425\u9500\u7cfb\u7edf\u53d1\u653e\u4e14\u5373\u5c06\u8fc7\u671f\u7684\u4f18\u60e0\u5238, taskMsg={}", JSONObject.toJSON((Object)taskMsg));
        EventRuleQueryReqDto dto = new EventRuleQueryReqDto();
        dto.setTriggerModeList(EventTriggerModeEnum.SINGLE_TRIGGER_BEFORE.getValue().toString());
        dto.setRuleStatus(RuleGroupStatusEnum.ABLE.getValue());
        dto.setEventCode("ex_coupon");
        List eventRuleDetailList = (List)this.eventRuleQueryApi.list(dto).getData();
        if (CollectionUtils.isEmpty((Collection)eventRuleDetailList)) {
            return true;
        }
        eventRuleDetailList.forEach(rule -> {
            JSONObject extension = JSONObject.parseObject((String)rule.getExtension());
            Integer day = extension.getInteger("day");
            List<CouponExtRespDto> couponExtRespDtos = this.queryExpireCoupons(TriggerTimeTypeEnum.BEFORE.getKey(), day);
            this.send(couponExtRespDtos, rule.getId());
        });
        return true;
    }

    private List<CouponExtRespDto> queryExpireCoupons(Integer type, Integer subDay) {
        DateTime dateTime = TriggerTimeTypeEnum.BEFORE.isEqual(type) ? DateTime.now().plusDays(subDay.intValue()) : (TriggerTimeTypeEnum.AFTER.isEqual(type) ? DateTime.now().minusDays(subDay.intValue()) : DateTime.now());
        DateTime start = dateTime.withTime(0, 0, 0, 0);
        DateTime end = dateTime.withTime(23, 59, 59, 0);
        CouponReqDto queryDto = new CouponReqDto();
        queryDto.setInvalidTimeStart(start.toDate());
        queryDto.setInvalidTimeEnd(end.toDate());
        queryDto.setCouponStatus(CouponStatusEnum.CREATE.getStatus());
        logger.info("\u67e5\u8be2\u8fc7\u671f\u4f18\u60e0\u5238\u7684\u53c2\u6570=={}", (Object)JSONObject.toJSONString((Object)queryDto));
        List couponExtRespDtos = this.couponExtQueryApi.searchData(queryDto);
        return couponExtRespDtos;
    }

    private void send(List<CouponExtRespDto> values, Long eventRuleId) {
        if (CollectionUtils.isEmpty(values)) {
            logger.info("\u672a\u67e5\u8be2\u5230\u6570\u636e\uff0c\u4efb\u52a1\u7ed3\u675f");
            return;
        }
        for (CouponExtRespDto value : values) {
            if (null == value.getUserId() || value.getUserId() < 1L) continue;
            CouponExtRespDto dto = new CouponExtRespDto();
            dto.setCouponName(value.getCouponName());
            dto.setCouponCode(value.getCouponCode());
            this.couponEventService.processExpireEvent(value.getUserId(), value.getCouponTemplateId(), dto, eventRuleId);
        }
    }

    public void after(TaskMsg taskMsg) {
    }
}

