/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.schedule;

import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.yundt.cube.biz.account.api.IMemberCardApi;
import com.dtyunxi.yundt.cube.biz.account.api.dto.request.MemberCardAccountUpdateReqDto;
import com.dtyunxi.yundt.cube.biz.member.api.common.constants.enums.ModuleType;
import com.dtyunxi.yundt.cube.biz.member.api.common.util.CenterMemberCheckUtil;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponCheckPointEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.constants.enums.InstallmentStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.constants.enums.InstallmentTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.promotion.service.IInstallmentService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.promotion.service.IMarketingPointService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.promotion.service.query.IInstallmentQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.coupon.service.ICouponTemplateService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ActivityEngineClient;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.promotion.das.InstallmentDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.CouponTemplateEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.promotion.InstallmentDetailEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.promotion.InstallmentEo;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="installmentTaskSchedule")
public class InstallmentTaskSchedule
extends SingleTupleScheduleEvent {
    private static final Logger logger = LoggerFactory.getLogger(InstallmentTaskSchedule.class);
    @Resource
    private IInstallmentQueryService installmentQueryService;
    @Resource
    private InstallmentDas installmentDas;
    @Resource
    private IInstallmentService installmentService;
    @Resource
    private IMemberCardApi memberCardApi;
    @Resource
    private ICouponTemplateService couponTemplateService;
    @Resource
    private ActivityEngineClient activityEngineClient;
    @Resource
    private IMarketingPointService marketingPointService;

    public void before(TaskMsg taskMsg) {
        logger.info("\u6267\u884c\u8425\u9500\u5206\u671f\u4efb\u52a1\u5f00\u59cb");
    }

    public boolean execute(TaskMsg taskMsg) {
        List<InstallmentDetailEo> needDoList = this.installmentQueryService.queryNeedDoByDate(new Date());
        if (CollectionUtils.isNotEmpty(needDoList)) {
            logger.info("\u5f53\u5929\u9700\u8981\u6267\u884c\u7684\u5206\u671f\u6761\u6570\u4e3a\uff1a{}", (Object)needDoList.size());
            for (InstallmentDetailEo detailEo : needDoList) {
                try {
                    String tradeNo = this.doWord(detailEo);
                    this.installmentService.done(detailEo.getId(), InstallmentStatusEnum.SUCCESS, tradeNo, null);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    logger.warn("\u5206\u671f\u53d1\u9001\u79ef\u5206/\u50a8\u503c\u5f02\u5e38:{}", (Object)e.getMessage());
                    this.installmentService.done(detailEo.getId(), InstallmentStatusEnum.FAIL, null, e.getMessage());
                }
            }
        } else {
            logger.info("\u5f53\u5929\u9700\u8981\u6267\u884c\u5206\u671f\u5217\u8868\u4e3a\u7a7a\uff01");
        }
        return true;
    }

    private String doWord(InstallmentDetailEo detailEo) {
        InstallmentEo installmentEo = (InstallmentEo)this.installmentDas.selectByPrimaryKey(detailEo.getInstallmentId());
        if (Objects.equals(installmentEo.getType(), InstallmentTypeEnum.POINTS.getType())) {
            if (CenterMemberCheckUtil.isLoadModule((ModuleType)ModuleType.POINT)) {
                return this.sendPoint(installmentEo, detailEo);
            }
            return "";
        }
        if (Objects.equals(installmentEo.getType(), InstallmentTypeEnum.STORED_VALUE.getType())) {
            return this.sendValue(installmentEo, detailEo);
        }
        if (Objects.equals(installmentEo.getType(), InstallmentTypeEnum.COUPON.getType())) {
            return this.sendCoupon(installmentEo, detailEo);
        }
        throw new BusinessRuntimeException("\u627e\u4e0d\u5230\u7c7b\u578b\uff1a" + installmentEo.getType());
    }

    private String sendPoint(InstallmentEo installmentEo, InstallmentDetailEo detailEo) {
        Date expiredDate = null;
        if (installmentEo.getValidityDay() != null && installmentEo.getValidityDay() > 0) {
            expiredDate = this.getExpiredDate(installmentEo.getValidityDay());
        }
        return this.marketingPointService.sendPointByInstallment(installmentEo, detailEo, expiredDate);
    }

    private String sendValue(InstallmentEo installmentEo, InstallmentDetailEo detailEo) {
        MemberCardAccountUpdateReqDto reqDto = new MemberCardAccountUpdateReqDto();
        reqDto.setMemberId(installmentEo.getUserId());
        reqDto.setTradeId(String.valueOf(detailEo.getId()));
        reqDto.setGiveAmount(detailEo.getNum());
        this.memberCardApi.updateAmount(reqDto);
        return null;
    }

    private String sendCoupon(InstallmentEo installmentEo, InstallmentDetailEo detailEo) {
        CouponTemplateEo couponTemplateEo = this.couponTemplateService.getCouponTemplateById(installmentEo.getObjId());
        if (couponTemplateEo == null) {
            throw new BusinessRuntimeException("\u627e\u4e0d\u5230\u4f18\u60e0\u5238\u6a21\u677f\uff1a" + installmentEo.getObjId());
        }
        EngineParams sendParam = new EngineParams();
        sendParam.setActivityId(couponTemplateEo.getActivityId().longValue());
        sendParam.setCouponTemplateId(couponTemplateEo.getId().longValue());
        sendParam.setUserId(installmentEo.getUserId());
        int sendNum = detailEo.getNum().intValue();
        for (int i = 0; i < sendNum; ++i) {
            try {
                this.activityEngineClient.defineCheckpoint(CouponCheckPointEnum.RECEIVE_COUPON.toString()).execute(sendParam);
                continue;
            }
            catch (Exception e) {
                logger.warn("\u53d1\u9001\u4f18\u60e0\u5238\u5931\u8d25{}", (Object)e.getMessage());
                e.printStackTrace();
            }
        }
        return null;
    }

    private Date getExpiredDate(Integer recycle) {
        Calendar ca = Calendar.getInstance();
        ca.add(5, recycle);
        return ca.getTime();
    }

    public void after(TaskMsg taskMsg) {
        logger.info("\u6267\u884c\u8425\u9500\u5206\u671f\u4efb\u52a1\u7ed3\u675f");
    }
}

