/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityItemReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.EnableStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common.BaseActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.PromotionActivityItemDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.exchange.ExchangeActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.ActivityItemTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.model.ExcItemDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.IExchangeActivityService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.IItem;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.condition.ActivityFactory;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.condition.ConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.impl.AbstractActivityService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.impl.MarketingModuleHelper;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ExchangeActivityServiceImpl
extends AbstractActivityService
implements IExchangeActivityService {
    @Resource
    private IContext context;
    @Resource
    private MarketingModuleHelper marketingModuleHelper;
    @Resource(name="activityQueryApiImpl")
    private IActivityQueryApi activityQueryApi;
    @Resource
    private IItem itemService;

    @Override
    public Long add(ExchangeActivityDto activityReqDto) {
        this.validate(activityReqDto);
        activityReqDto.setActivityCode(this.marketingModuleHelper.generateCode("EXC"));
        return this.addActivity(activityReqDto);
    }

    private void validate(ExchangeActivityDto activityReqDto) {
        if (activityReqDto.getActivityType() == null) {
            throw new BizException("\u6d3b\u52a8\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        if (CollectionUtils.isEmpty((Collection)activityReqDto.getActivityItems())) {
            throw new BizException("\u6d3b\u52a8\u9002\u7528\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Set itemShopIds = activityReqDto.getActivityItems().stream().map(PromotionActivityItemDto::getShopId).collect(Collectors.toSet());
        if (itemShopIds.size() > 1) {
            throw new BizException("\u6d3b\u52a8\u9002\u7528\u7684\u5546\u54c1\u5e97\u94fa\u5fc5\u987b\u4e00\u81f4");
        }
        activityReqDto.getPromotionContents().forEach(content -> {
            if (content.getThreshold() == null) {
                throw new BizException("\u4fc3\u9500\u6761\u4ef6\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (CollectionUtils.isEmpty((Collection)content.getExchangeItems())) {
                throw new BizException("\u6362\u8d2d\u5546\u54c1\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
            }
            Set excShopIds = content.getExchangeItems().stream().map(ExcItemDto::getShopId).collect(Collectors.toSet());
            if (excShopIds.size() > 1) {
                throw new BizException("\u6362\u8d2d\u5546\u54c1\u7684\u5e97\u94fa\u5fc5\u987b\u4e00\u81f4");
            }
            if (!itemShopIds.containsAll(excShopIds)) {
                throw new BizException("\u6d3b\u52a8\u9002\u7528\u7684\u5546\u54c1\u4e0e\u6362\u8d2d\u5546\u54c1\u5e97\u94fa\u5fc5\u987b\u4e00\u81f4");
            }
            for (ExcItemDto excItemDto : content.getExchangeItems()) {
                String excItemErrMsg = "\u6362\u8d2d\u5546\u54c1[" + excItemDto.getItemName() + "]";
                if (CollectionUtils.isEmpty((Collection)excItemDto.getExcSkuDtos())) {
                    throw new BizException(excItemErrMsg + "\u89c4\u683c\u4e0d\u80fd\u4e3a\u7a7a");
                }
                excItemDto.getExcSkuDtos().forEach(excSkuDto -> {
                    if (null == excSkuDto.getExchangeNum()) {
                        throw new BizException(excItemErrMsg + "\u5355\u6b21\u6362\u8d2d\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    BigDecimal sellPrice = this.itemService.queryItemPrice(excItemDto.getShopId(), excItemDto.getItemId(), excSkuDto.getSkuId());
                    if (CollectionUtils.isEmpty((Collection)excSkuDto.getLevelPriceDtos())) {
                        throw new BizException(excItemErrMsg + "\u6362\u8d2d\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    excSkuDto.getLevelPriceDtos().forEach(levelPriceDto -> {
                        if (levelPriceDto.getPrice() == null) {
                            throw new BizException(excItemErrMsg + "\u6362\u8d2d\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        if (levelPriceDto.getPrice().compareTo(sellPrice) > 0) {
                            throw new BizException(excItemErrMsg + "\u6362\u8d2d\u4ef7\u683c\u4e0d\u80fd\u5927\u4e8e\u96f6\u552e\u4ef7\u683c");
                        }
                    });
                });
            }
        });
    }

    @Override
    public ExchangeActivityDto getDetail(Long id) {
        ActivityRespDto activityRespDto = (ActivityRespDto)this.activityQueryApi.queryActivityFatDetail(id.longValue()).getData();
        if (activityRespDto == null) {
            return null;
        }
        ExchangeActivityDto exchangeActivityDto = new ExchangeActivityDto();
        CubeBeanUtils.copyProperties((Object)exchangeActivityDto, (Object)activityRespDto, (String[])new String[0]);
        exchangeActivityDto.setActivityType(ActivityType.getByType((Long)activityRespDto.getActivityTemplateId()));
        List<ConditionTemplate> templateList = ActivityFactory.getActivityTemplate(exchangeActivityDto.getActivityType());
        templateList.forEach(conditionTemplate -> conditionTemplate.parseCondition(activityRespDto.getConditionDtos(), exchangeActivityDto));
        return exchangeActivityDto;
    }

    @Override
    protected <T extends BaseActivityDto> List<ActivityItemReqDto> getActivityItems(T activityReqDto) {
        ExchangeActivityDto activityDto = (ExchangeActivityDto)activityReqDto;
        ArrayList activityItemReqDtos = Lists.newArrayList();
        activityDto.getActivityItems().stream().forEach(itemDto -> itemDto.getSkus().forEach(skuDto -> {
            ActivityItemReqDto activityItemReqDto = new ActivityItemReqDto();
            activityItemReqDto.setItemId(skuDto.getItemId());
            activityItemReqDto.setItemName(itemDto.getItemName());
            activityItemReqDto.setSkuId(skuDto.getSkuId());
            activityItemReqDto.setInstanceId(this.context.instanceId());
            activityItemReqDto.setTenantId(this.context.tenantId());
            activityItemReqDto.setItemType(ActivityItemTypeEnum.ITEM.getKey());
            activityItemReqDto.setStatus(EnableStatusEnum.ENABLE);
            activityItemReqDto.setOriginalStock(Long.valueOf(null != skuDto.getStock() ? skuDto.getStock() : 0L));
            activityItemReqDto.setRemainingStock(Long.valueOf(null != skuDto.getStock() ? skuDto.getStock() : 0L));
            activityItemReqDto.setActivityPrice(skuDto.getPromotionPrice() == null ? BigDecimal.ZERO : skuDto.getPromotionPrice());
            activityItemReqDto.setShopId(itemDto.getShopId());
            activityItemReqDtos.add(activityItemReqDto);
        }));
        return activityItemReqDtos;
    }
}

