/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityUserMappingQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityUserMappingReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityUserMappingService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ActivityUserMappingDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ActivityUserMappingEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.StdActivityUserMappingEo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActivityUserMappingServiceImpl
implements IActivityUserMappingService {
    @Resource
    private ActivityUserMappingDas activityUserMappingDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addActivityUserMapping(ActivityUserMappingReqDto activityUserMappingReqDto) {
        ArrayList<ActivityUserMappingEo> activityUserMappingEoList = new ArrayList<ActivityUserMappingEo>();
        List userId = activityUserMappingReqDto.getUserIdList();
        for (Long id : userId) {
            ActivityUserMappingEo activityUserMappingEo = new ActivityUserMappingEo();
            activityUserMappingEo.setUserId(id);
            activityUserMappingEo.setActivityId(activityUserMappingReqDto.getActivityId());
            activityUserMappingEo.setCustomerTypeId(activityUserMappingReqDto.getCustomerTypeIds());
            activityUserMappingEo.setCustomerAreaCode(activityUserMappingReqDto.getCustomerAreaCodes());
            activityUserMappingEo.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
            activityUserMappingEo.setTenantId(ServiceContext.getContext().getRequestTenantId());
            activityUserMappingEoList.add(activityUserMappingEo);
        }
        this.activityUserMappingDas.insertBatch(activityUserMappingEoList);
    }

    @Override
    public int countActivityUserMapping(ActivityUserMappingQueryReqDto activityUserMappingQueryReqDto) {
        ActivityUserMappingEo activityUserMappingEo = new ActivityUserMappingEo();
        activityUserMappingEo.setUserId(activityUserMappingQueryReqDto.getUserId());
        activityUserMappingEo.setActivityId(activityUserMappingQueryReqDto.getActivityId());
        activityUserMappingEo.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        activityUserMappingEo.setTenantId(ServiceContext.getContext().getRequestTenantId());
        return this.activityUserMappingDas.count((BaseEo)activityUserMappingEo);
    }

    @Override
    public void deleteActivityUserMapping(Long activityId) {
        ActivityUserMappingEo activityUserMappingEo = new ActivityUserMappingEo();
        activityUserMappingEo.setActivityId(activityId);
        activityUserMappingEo.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        activityUserMappingEo.setTenantId(ServiceContext.getContext().getRequestTenantId());
        this.activityUserMappingDas.logicDelete((BaseEo)activityUserMappingEo);
    }

    @Override
    public List<Long> queryByUserId(long userId) {
        ActivityUserMappingEo eo = ActivityUserMappingEo.newInstance();
        eo.setUserId(Long.valueOf(userId));
        LinkedList acIds = this.activityUserMappingDas.findListColumn((BaseEo)eo, new String[]{"activity_id"});
        if (null == acIds) {
            acIds = new LinkedList();
        }
        return acIds.stream().map(StdActivityUserMappingEo::getActivityId).collect(Collectors.toList());
    }

    @Override
    public List<ActivityUserMappingEo> queryByActivityId(Long activityId) {
        ActivityUserMappingEo eo = ActivityUserMappingEo.newInstance();
        eo.setActivityId(activityId);
        ArrayList activityUserMappingEos = this.activityUserMappingDas.findListColumn((BaseEo)eo, new String[0]);
        if (CollectionUtils.isEmpty((Collection)activityUserMappingEos)) {
            activityUserMappingEos = new ArrayList();
        }
        return activityUserMappingEos;
    }
}

