/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.timediscount.condition;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.crowdordering.dto.request.ActivityItemDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.Param;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ItemConditionTemplate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemTimeLimitCondition
extends ItemConditionTemplate {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String CONFIG_PARAM_KEY_ITEMS = "ItemTimeLimitCondition.items";

    @Override
    public <T extends EngineParams> boolean execute(TemplateDefine define, ConditionRespDto conditionRespDto, T context, Map<String, ?> configParams) {
        Param param = define.getParam(CONFIG_PARAM_KEY_ITEMS);
        if (null == param) {
            throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u5546\u54c1\u6761\u4ef6[items]\u672a\u914d\u7f6e"}));
        }
        List items = (List)ConditionTemplate.converter(configParams.get(CONFIG_PARAM_KEY_ITEMS), param, define.getLoadClass());
        if (CollectionUtils.isEmpty((Collection)items)) {
            return false;
        }
        boolean filterExcItem = context.getExtendsAttribute().getOrDefault("filterExcItem", false);
        List itemVos = context.getItems().stream().filter(itemVo -> {
            if (itemVo.getExchange() == 1) {
                return !filterExcItem;
            }
            return items.stream().anyMatch(item -> {
                String target = item.getItemId().toString();
                String source = itemVo.getItemId();
                if (null != itemVo.getSkuId()) {
                    target = target + item.getSkuId();
                    source = source + itemVo.getSkuId();
                }
                return target.equals(source);
            });
        }).collect(Collectors.toList());
        context.setItems(itemVos);
        return CollectionUtils.isNotEmpty(itemVos);
    }

    @Override
    public boolean apply(TemplateDefine define, ConditionRespDto conditionRespDto, ItemVo itemVo) {
        Param param = define.getParam(CONFIG_PARAM_KEY_ITEMS);
        if (null == param) {
            throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u5546\u54c1\u6761\u4ef6[items]\u672a\u914d\u7f6e"}));
        }
        JSONObject configParams = JSON.parseObject((String)conditionRespDto.getConditionParams());
        List items = (List)ConditionTemplate.converter(configParams.get(CONFIG_PARAM_KEY_ITEMS), param, define.getLoadClass());
        this.log.info("\u53c2\u4e0e\u4fc3\u9500\u6d3b\u52a8\u5546\u54c1items ={}", JSON.toJSON((Object)items));
        if (CollectionUtils.isEmpty((Collection)items)) {
            return false;
        }
        return items.stream().anyMatch(item -> {
            String target = item.getItemId().toString();
            String source = itemVo.getItemId();
            if (null != itemVo.getSkuId()) {
                target = target + item.getSkuId();
                source = source + itemVo.getSkuId();
            }
            target = target + item.getShopId();
            source = source + itemVo.getShopId();
            return target.equals(source);
        });
    }

    @Override
    public Set<ActivityItemDto> getItems(TemplateDefine define, ConditionRespDto conditionRespDto, Map<String, ?> configParams) {
        Param param = define.getParam(CONFIG_PARAM_KEY_ITEMS);
        if (null == param) {
            return Collections.EMPTY_SET;
        }
        List items = (List)ConditionTemplate.converter(configParams.get(CONFIG_PARAM_KEY_ITEMS), param, define.getLoadClass());
        if (CollectionUtils.isEmpty((Collection)items)) {
            return Collections.EMPTY_SET;
        }
        return items.stream().map(timeDisActItem -> {
            ActivityItemDto activityItemDto = new ActivityItemDto();
            BeanUtil.copyProperties((Object)timeDisActItem, (Object)activityItemDto, (String[])new String[0]);
            return activityItemDto;
        }).collect(Collectors.toSet());
    }
}

