/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.fullAttach;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.Param;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ConditionTemplate;
import java.math.BigDecimal;
import java.util.Map;

public class OrderAmountCheckCondition
extends ConditionTemplate {
    private static final String ORDER_AMOUNT = "OrderAmountCheckCondition.orderAmount";

    @Override
    public <T extends EngineParams> boolean execute(TemplateDefine templateDefine, ConditionRespDto conditionRespDto, T context, Map<String, ?> configParams) {
        Param param = templateDefine.getParam(ORDER_AMOUNT);
        if (null == param) {
            throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u6ee1\u8d60\u6d3b\u52a8\uff1a\u8ba2\u5355\u91d1\u989d\u6821\u9a8c\u6761\u4ef6\u672a\u914d\u7f6e"}));
        }
        String orderAmountStr = (String)ConditionTemplate.converter(configParams.get(ORDER_AMOUNT), param, templateDefine.getLoadClass());
        BigDecimal orderAmount = new BigDecimal(orderAmountStr);
        BigDecimal totalItemAmount = new BigDecimal(0);
        for (ItemVo itemVo : context.getItems()) {
            totalItemAmount = totalItemAmount.add(itemVo.getDiscountPrice());
        }
        if (totalItemAmount.compareTo(orderAmount) < 0) {
            throw new BizException("\u8ba2\u5355\u91d1\u989d\u672a\u6ee1\u8db3\u6761\u4ef6\uff0c\u65e0\u6cd5\u53c2\u4e0e\u8be5\u6d3b\u52a8");
        }
        return true;
    }
}

