/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.converter.promotion.condition;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ConditionTemplateType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IConditionQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service.query.ICouponTemplateExtQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.constants.enums.ObjectType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.constants.enums.ReturnType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.ConditionDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.Coupon;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.Gift;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.GiftRdm;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.Promotion;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.PromotionDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.PromotionInfoDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.PromotionRulesDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.response.PresentDetailExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.response.PromotionInfoRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.service.IPresentApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.utils.MapUtils;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.converter.promotion.condition.AbstractBaseTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.promotion.service.query.IPresentQueryService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.util.StringUtils;

public class ReturningPresentCondition
extends AbstractBaseTemplate {
    @Override
    public boolean support(ActivityType type) {
        return ActivityType.FULL_RETURNING_ACTIVITY.equals((Object)type) || ActivityType.FULL_PRESENT_ACTIVITY.equals((Object)type);
    }

    @Override
    public long getConditionTemplateId() {
        return ConditionTemplateType.RETURN_GIFT.getId();
    }

    @Override
    public long getRuleId() {
        return 1196945569812278402L;
    }

    @Override
    public Map<String, Object> processRule(PromotionDto dto) {
        PromotionInfoDto info = (PromotionInfoDto)dto;
        HashMap<String, Object> param = new HashMap<String, Object>(3);
        ArrayList mapList = new ArrayList(4);
        for (PromotionRulesDto rule : info.getRuleDtos()) {
            HashMap<String, Object> temp = new HashMap<String, Object>(3);
            temp.put("returnType", rule.getReturnType());
            temp.put("condition", rule.getCondition());
            temp.put("returnNum", rule.getDiscountValue());
            temp.put("random", rule.isRandom());
            temp.put("objectType", rule.getObjectType());
            temp.put("objGroupId", rule.getObjectGroupId());
            temp.put("limitAmount", rule.getLimitAmount());
            temp.put("priceType", rule.getPriceType());
            mapList.add(temp);
        }
        param.put("ReturnAndGiftCondition.condition", mapList);
        if (ActivityType.FULL_RETURNING_ACTIVITY.equals((Object)dto.getInfoDto().getActivityType())) {
            param.put("ReturnAndGiftCondition.type", 2);
        } else {
            param.put("ReturnAndGiftCondition.type", 3);
        }
        return param;
    }

    @Override
    public void prepare(PromotionDto dto) {
        PromotionInfoDto info = (PromotionInfoDto)dto;
        IPresentApi presentApi = (IPresentApi)SpringBeanUtil.getBean(IPresentApi.class);
        if (dto.getActivityId() > 0L) {
            IConditionQueryApi conditionQueryApi = (IConditionQueryApi)SpringBeanUtil.getBean(IConditionQueryApi.class);
            List conditionRespDtos = conditionQueryApi.queryConditions((List)Lists.newArrayList((Object[])new Long[]{info.getActivityId()}), this.getConditionTemplateId());
            if (CollectionUtils.isNotEmpty((Collection)conditionRespDtos)) {
                conditionRespDtos.forEach(allCondition -> {
                    JSONObject jsonObject = JSON.parseObject((String)allCondition.getConditionParams());
                    JSONArray condition = jsonObject.getJSONArray("ReturnAndGiftCondition.condition");
                    if (CollectionUtils.isNotEmpty((Collection)condition)) {
                        ArrayList forDeleteItemGroupIds = Lists.newArrayList();
                        condition.forEach(detail -> {
                            ObjectType objType;
                            JSONObject obj = (JSONObject)detail;
                            String objTypeStr = obj.getString("objectType");
                            if (!StringUtils.isEmpty((Object)objTypeStr) && (objType = ObjectType.valueOf((String)obj.getString("objectType"))).equals((Object)ObjectType.SINGLE)) {
                                forDeleteItemGroupIds.add(obj.getLong("objGroupId"));
                            }
                        });
                        if (!CollectionUtils.isEmpty((Collection)forDeleteItemGroupIds)) {
                            forDeleteItemGroupIds.forEach(id -> presentApi.deletePresentGroup(id, false));
                        }
                    }
                });
            }
        }
        this.addSinglePresentGroup(dto, info.getRuleDtos());
    }

    @Override
    public List<ConditionDto> changeToRules(ConditionRespDto conditionRespDto, PromotionInfoRespDto resp) {
        ArrayList ruleList = Lists.newArrayList();
        JSONObject conditionObj = JSON.parseObject((String)conditionRespDto.getConditionParams());
        List conditionArr = JSON.parseArray((String)conditionObj.getString("ReturnAndGiftCondition.condition"), JSONObject.class);
        if (!CollectionUtils.isEmpty((Collection)conditionArr)) {
            conditionArr.forEach(condition -> {
                PromotionRulesDto rulesDto = PromotionRulesDto.defaultInstance((Map)condition);
                rulesDto.setReturnType(ReturnType.valueOf((String)MapUtils.getString((Map)condition, (Object)"returnType")));
                rulesDto.setDiscountValue(MapUtils.getString((Map)condition, (Object)"returnNum"));
                rulesDto.setObjectId(MapUtils.getLongValue((Map)condition, (Object)"objId"));
                long groupId = MapUtils.getLongValue((Map)condition, (Object)"objGroupId");
                if (groupId > 0L) {
                    if (rulesDto.getObjectType().equals((Object)ObjectType.SINGLE)) {
                        this.fillGirtGroupInfo(rulesDto, groupId, false);
                    } else {
                        this.fillGirtGroupInfo(rulesDto, groupId, true);
                    }
                }
                rulesDto.setRandom(MapUtils.getBooleanValue((Map)condition, (Object)"random"));
                ruleList.add(rulesDto);
            });
        }
        return ruleList;
    }

    @Override
    public void changeToLPPZPromotion(ConditionDto c, String activityId, PromotionInfoRespDto localPromotion, Promotion promotion) {
        if (!(c instanceof PromotionRulesDto)) {
            return;
        }
        if (ActivityType.FULL_RETURNING_ACTIVITY.equals((Object)localPromotion.getInfoDto().getActivityType())) {
            promotion.setPromType("C");
        } else {
            promotion.setPromType("D");
        }
        PromotionRulesDto rule = (PromotionRulesDto)c;
        if (3 == rule.getCondition()) {
            promotion.setLadde(true);
        }
        Promotion newP = promotion.clone();
        newP.setDiscount(rule.getPriceType(), rule.getLimitAmount());
        newP.setCondition(rule.getCondition(), promotion.getPromId());
        promotion.addSubPromotions(newP);
        IPresentQueryService presentQueryService = (IPresentQueryService)SpringBeanUtil.getBean(IPresentQueryService.class);
        if (ReturnType.ITEM.equals((Object)rule.getReturnType())) {
            if (rule.isRandom()) {
                if (StringUtils.isEmpty((Object)rule.getObjCode())) {
                    PresentDetailExtRespDto presentDetailExtRespDto = presentQueryService.queryDetailExtById(rule.getObjectGroupId());
                    Set giftRdmSet = presentDetailExtRespDto.getPresentList().stream().map(item -> {
                        GiftRdm rdm = new GiftRdm();
                        rdm.setSku(item.getCode());
                        rdm.setPromId(newP.getPromId());
                        return rdm;
                    }).collect(Collectors.toSet());
                    newP.getGiftRdms().addAll(giftRdmSet);
                } else {
                    GiftRdm rdm = new GiftRdm();
                    rdm.setQuantity(Integer.valueOf(Integer.parseInt(rule.getDiscountValue())));
                    rdm.setSku(rule.getObjCode());
                    rdm.setPromId(newP.getPromId());
                    newP.getGiftRdms().add(rdm);
                }
            } else if (StringUtils.isEmpty((Object)rule.getObjCode())) {
                PresentDetailExtRespDto presentDetailExtRespDto = presentQueryService.queryDetailExtById(rule.getObjectGroupId());
                Set giftRdmSet = presentDetailExtRespDto.getPresentList().stream().map(item -> {
                    Gift gift = new Gift();
                    gift.setSku(item.getCode());
                    gift.setPromId(newP.getPromId());
                    return gift;
                }).collect(Collectors.toSet());
                newP.getGifts().addAll(giftRdmSet);
            } else {
                Gift rdm = new Gift();
                rdm.setQuantity(Integer.valueOf(Integer.parseInt(rule.getDiscountValue())));
                rdm.setSku(rule.getObjCode());
                rdm.setPromId(newP.getPromId());
                newP.getGifts().add(rdm);
            }
        } else if (ReturnType.COUPON.equals((Object)rule.getReturnType())) {
            Set templateIds;
            PresentDetailExtRespDto presentDetailExtRespDto = presentQueryService.queryDetailExtById(rule.getObjectGroupId());
            ICouponTemplateExtQueryApi couponTemplateQueryApi = (ICouponTemplateExtQueryApi)SpringBeanUtil.getBean(ICouponTemplateExtQueryApi.class);
            List coupons = (List)couponTemplateQueryApi.queryByIds((List)Lists.newArrayList((templateIds = presentDetailExtRespDto.getPresentList().stream().map(pre -> Long.parseLong(pre.getObjId())).collect(Collectors.toSet())).iterator())).getData();
            if (!CollectionUtils.isEmpty((Collection)coupons)) {
                List collect = coupons.stream().map(Coupon::newInstance).collect(Collectors.toList());
                newP.getRtnCoupons().addAll(collect);
            }
        } else if (ReturnType.POSTAGE.equals((Object)rule.getReturnType())) {
            newP.setFreepost(true);
        }
    }
}

