/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.promotion.apiimpl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityCreateReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.AuditStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.IActivityApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.PromotionBaseInfoDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.PromotionDepositInfoDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.PromotionDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.PromotionInfoDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.PromotionPointInfoDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.service.IPromotionApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.converter.promotion.action.ActionFactory;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.converter.promotion.condition.ActivityFactory;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="promotionApi")
public class PromotionApiImpl
implements IPromotionApi {
    @Resource(name="activityApiImpl")
    private IActivityApi activityApi;
    @Resource(name="activityQueryApiImpl")
    private IActivityQueryApi activityQueryApi;

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Long> add(@Valid PromotionInfoDto addPromotion) {
        return this.activityApi.add(this.createActivity((PromotionDto)addPromotion));
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> updatePromotion(long promotionId, @Valid PromotionInfoDto updatePromotion) {
        updatePromotion.setActivityId(promotionId);
        this.activityApi.modifyById(promotionId, this.createActivity((PromotionDto)updatePromotion));
        return RestResponse.VOID;
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> updatePromotion(long promotionId, @Valid PromotionPointInfoDto updatePromotion) {
        updatePromotion.setActivityId(promotionId);
        this.activityApi.modifyById(promotionId, this.createActivity((PromotionDto)updatePromotion));
        return RestResponse.VOID;
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> updatePromotion(long promotionId, @Valid PromotionDepositInfoDto updatePromotion) {
        updatePromotion.setActivityId(promotionId);
        this.activityApi.modifyById(promotionId, this.createActivity((PromotionDto)updatePromotion));
        return RestResponse.VOID;
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Long> addRedeemPoints(@Valid PromotionPointInfoDto addPromotion) {
        return this.activityApi.add(this.createActivity((PromotionDto)addPromotion));
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Long> addRedeemDeposit(@Valid PromotionDepositInfoDto addPromotion) {
        return this.activityApi.add(this.createActivity((PromotionDto)addPromotion));
    }

    private ActivityCreateReqDto createActivity(PromotionDto dto) {
        this.checkActivityName(dto);
        this.checkMutex(dto);
        ActivityCreateReqDto activityCreateReqDto = new ActivityCreateReqDto();
        ActivityDto activityDto = this.getActivityDto(dto.getInfoDto());
        activityDto.setId(Long.valueOf(dto.getActivityId()));
        LinkedList conditionList = new LinkedList();
        ActivityFactory.getActivityTemplate(dto.getInfoDto().getActivityType()).forEach(e -> conditionList.add(e.changeToCondition(dto)));
        activityCreateReqDto.setConditions(conditionList);
        activityCreateReqDto.setActivityDto(activityDto);
        LinkedList actions = new LinkedList();
        ActionFactory.getActionTemplate(dto.getInfoDto().getActivityType()).forEach(e -> actions.add(e.getActionReqDto()));
        activityCreateReqDto.setActions(actions);
        return activityCreateReqDto;
    }

    private ActivityDto getActivityDto(PromotionBaseInfoDto baseInfo) {
        ActivityDto activityDto = new ActivityDto();
        CubeBeanUtils.copyProperties((Object)activityDto, (Object)baseInfo, (String[])new String[0]);
        activityDto.setAuditStatusEnum(AuditStatusEnum.WAIT_AUDIT);
        activityDto.setActivityStatusEnum(ActivityStatusEnum.NEW);
        activityDto.setActivityTemplateId(Long.valueOf(baseInfo.getActivityType().getId()));
        activityDto.setRemark(baseInfo.getDesc());
        HashMap<String, Object> extendFiled = new HashMap<String, Object>();
        extendFiled.put("activityItemRange", baseInfo.getPromotionType());
        extendFiled.put("plainId", baseInfo.getPromotionPlainId());
        extendFiled.put("mutexLevel", baseInfo.getMutex());
        extendFiled.put("o2oChannel", baseInfo.getO2oChannel());
        extendFiled.put("activityCode", baseInfo.getActivityType().acronym().append(IdGenrator.getDistributedId()));
        activityDto.setExtFields(extendFiled);
        return activityDto;
    }

    private void checkMutex(PromotionDto dto) {
        ActivityRespDto activity;
        Map extFields;
        int sourceMutex;
        if (dto.getInfoDto().getMutex() == 0) {
            return;
        }
        if (dto.getActivityId() > 0L && (sourceMutex = MapUtils.getIntValue((Map)(extFields = (activity = (ActivityRespDto)this.activityQueryApi.queryActivityFatDetail(dto.getActivityId()).getData()).getExtFields()), (Object)"mutexLevel")) == dto.getInfoDto().getMutex()) {
            return;
        }
        ActivityDto forQuery = new ActivityDto();
        forQuery.setActivityTemplateId(Long.valueOf(dto.getInfoDto().getActivityType().getId()));
        HashMap extMap = Maps.newHashMap();
        extMap.put("mutexLevel", dto.getInfoDto().getMutex());
        forQuery.setExtFields((Map)extMap);
        forQuery.setActivityStatusEnum(ActivityStatusEnum.NEW);
        List newList = (List)this.activityQueryApi.queryActivityList(forQuery).getData();
        if (CollectionUtils.isNotEmpty((Collection)newList)) {
            throw new BizException("\u5df2\u5b58\u5728\u76f8\u540c\u6743\u91cd\u7684\u6d3b\u52a8");
        }
        forQuery.setActivityStatusEnum(ActivityStatusEnum.READY);
        List readyList = (List)this.activityQueryApi.queryActivityList(forQuery).getData();
        if (CollectionUtils.isNotEmpty((Collection)readyList)) {
            throw new BizException("\u5df2\u5b58\u5728\u76f8\u540c\u6743\u91cd\u7684\u6d3b\u52a8");
        }
        forQuery.setActivityStatusEnum(ActivityStatusEnum.ACTIVATE);
        List activityList = (List)this.activityQueryApi.queryActivityList(forQuery).getData();
        if (CollectionUtils.isNotEmpty((Collection)activityList)) {
            throw new BizException("\u5df2\u5b58\u5728\u76f8\u540c\u6743\u91cd\u7684\u6d3b\u52a8");
        }
    }

    private void checkActivityName(PromotionDto dto) {
        ActivityRespDto activity;
        String activityName = dto.getInfoDto().getActivityName();
        ActivityDto forQuery = new ActivityDto();
        forQuery.setActivityName(activityName);
        if (dto.getActivityId() > 0L && Objects.equals(activityName, (activity = (ActivityRespDto)this.activityQueryApi.queryActivityFatDetail(dto.getActivityId()).getData()).getActivityName())) {
            return;
        }
        RestResponse listRestResponse = this.activityQueryApi.queryActivityList(forQuery);
        if ("0".equals(listRestResponse.getResultCode())) {
            List activityList = (List)listRestResponse.getData();
            if (CollectionUtils.isNotEmpty((Collection)activityList)) {
                throw new BizException("\u5df2\u5b58\u5728\u76f8\u540c\u540d\u79f0\u7684\u6d3b\u52a8");
            }
        } else {
            throw new BizException("\u67e5\u8be2\u5f53\u524d\u6d3b\u52a8\u51fa\u9519");
        }
    }
}

