/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.promotion.service.query.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.ItemsReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ItemsRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.promotion.service.query.IItemsQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.utils.PageInfoConvert;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ItemsDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.vo.ItemsVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.ItemsEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.StdItemsEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="itemsQueryService")
public class ItemsQueryServiceImpl
implements IItemsQueryService {
    @Resource
    private ItemsDas itemsDas;

    @Override
    public ItemsRespDto queryById(Long id) {
        ItemsEo itemsEo = (ItemsEo)this.itemsDas.selectByPrimaryKey(id);
        if (itemsEo != null) {
            ItemsRespDto respDto = new ItemsRespDto();
            CubeBeanUtils.copyProperties((Object)respDto, (Object)itemsEo, (String[])new String[0]);
            return respDto;
        }
        return null;
    }

    @Override
    public ItemsRespDto queryByCode(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        ItemsEo forQuery = new ItemsEo();
        forQuery.setCode(code);
        ItemsEo itemsEo = (ItemsEo)this.itemsDas.selectOne((BaseEo)forQuery);
        if (itemsEo != null) {
            ItemsRespDto respDto = new ItemsRespDto();
            CubeBeanUtils.copyProperties((Object)respDto, (Object)itemsEo, (String[])new String[0]);
            return respDto;
        }
        return null;
    }

    @Override
    public List<ItemsRespDto> queryByCondition(ItemsReqDto reqDto) {
        ItemsEo forQuery = new ItemsEo();
        CubeBeanUtils.copyProperties((Object)forQuery, (Object)reqDto, (String[])new String[0]);
        this.setNameLike(forQuery);
        List eos = this.itemsDas.select((BaseEo)forQuery);
        if (CollectionUtils.isNotEmpty((Collection)eos)) {
            ArrayList dtoList = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)dtoList, (Collection)eos, ItemsRespDto.class);
            return dtoList;
        }
        return null;
    }

    @Override
    public PageInfo<ItemsRespDto> queryByPage(String filters, Integer pageNum, Integer pageSize) {
        if (StringUtils.isEmpty((CharSequence)filters)) {
            filters = "{}";
        }
        ItemsReqDto reqDto = (ItemsReqDto)JSON.parseObject((String)filters, ItemsReqDto.class);
        ItemsVo forQuery = new ItemsVo();
        CubeBeanUtils.copyProperties((Object)forQuery, (Object)reqDto, (String[])new String[0]);
        PageInfo itemsEoPageInfo = this.itemsDas.selectConditionPage(forQuery, pageNum, pageSize);
        return PageInfoConvert.convert(itemsEoPageInfo, ItemsRespDto.class);
    }

    @Override
    public List<ItemsRespDto> queryByIds(List<Long> ids) {
        if (CollectionUtils.isNotEmpty(ids)) {
            ItemsEo forQuery = new ItemsEo();
            forQuery.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{new SqlFilter("id", SqlFilter.Operator.in, ids)}));
            List eos = this.itemsDas.select((BaseEo)forQuery);
            if (CollectionUtils.isNotEmpty((Collection)eos)) {
                ArrayList dtoList = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)dtoList, (Collection)eos, ItemsRespDto.class);
                return dtoList;
            }
        }
        return null;
    }

    @Override
    public List<ItemsRespDto> queryByCods(List<String> codes) {
        if (CollectionUtils.isNotEmpty(codes)) {
            ItemsEo forQuery = new ItemsEo();
            forQuery.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{new SqlFilter("code", SqlFilter.Operator.in, codes)}));
            List eos = this.itemsDas.select((BaseEo)forQuery);
            if (CollectionUtils.isNotEmpty((Collection)eos)) {
                ArrayList dtoList = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)dtoList, (Collection)eos, ItemsRespDto.class);
                return dtoList;
            }
        }
        return null;
    }

    @Override
    public List<String> queryCodesByName(String itemName) {
        if (StringUtils.isNotEmpty((CharSequence)itemName)) {
            ItemsEo forQuery = new ItemsEo();
            forQuery.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.like((String)"name", (Object)("%" + itemName + "%"))}));
            List eos = this.itemsDas.select((BaseEo)forQuery);
            if (CollectionUtils.isNotEmpty((Collection)eos)) {
                return eos.stream().map(StdItemsEo::getCode).collect(Collectors.toList());
            }
        }
        return null;
    }

    @Override
    public int countItem() {
        return this.itemsDas.countItem();
    }

    private void setNameLike(ItemsEo forQuery) {
        if (StringUtils.isNotEmpty((CharSequence)forQuery.getName())) {
            forQuery.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{new SqlFilter("name", SqlFilter.Operator.like, (Object)("%" + forQuery.getName() + "%"))}));
            forQuery.setName(null);
        }
    }
}

