/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.impl.serializa;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.icommerce.utils.BizExceptionHelper;
import com.dtyunxi.icommerce.utils.IExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common.CouponTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common.CouponUseTimeDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common.DynamicDate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponValidityTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.ISerializeCouPonUseTimeValue;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.enums.MarketingModuleExcpCode;
import org.springframework.stereotype.Component;

@Component
public class SerializeCouPonUseTimeValueByToday
implements ISerializeCouPonUseTimeValue {
    private static final Integer TYPE = 1;
    private static final Integer TODAY = 1;
    private static final Integer NEXT_DAY = 2;

    @Override
    public Integer getType() {
        return TYPE;
    }

    @Override
    public void serialize(CouponTemplate couponTemplate) {
        CouponUseTimeDto couponUseTimeDto = couponTemplate.getCouponUseTimeReqDto();
        if (couponUseTimeDto.getValue() == null) {
            BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.COUPON_TP_USE_TIME_RANGE_UNDEFINED);
        }
        if (couponUseTimeDto.getValue() instanceof Integer || couponUseTimeDto.getValue() instanceof Byte) {
            DynamicDate dynamicDate = new DynamicDate();
            if (this.getType() == TYPE) {
                dynamicDate.setAfterDate(TODAY);
            } else {
                dynamicDate.setAfterDate(NEXT_DAY);
            }
            dynamicDate.setDay(Integer.valueOf(Integer.parseInt(couponUseTimeDto.getValue().toString())));
            couponTemplate.setValidityType(CouponValidityTypeEnum.DYNAMIC_DATE.getType());
            couponTemplate.setDynamicDate(JSONObject.toJSONString((Object)dynamicDate));
        } else {
            BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.COUPON_TP_USE_TIME_RANGE_UNDEFINED);
        }
    }
}

