/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActionTemplateQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActionTemplateReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActionTemplateRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActionTemplateService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.ITriggerService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.BatchOperationUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.BeanCopyUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ActionTemplateDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ActionTemplateEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.TriggerEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActionTemplateServiceImpl
implements IActionTemplateService {
    @Autowired
    private ActionTemplateDas actionTemplateDas;
    @Autowired
    private ITriggerService triggerService;

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public void delActionTemplate(@Min(value=1L, message="\u6d3b\u52a8\u6a21\u7248ID\u4e0d\u80fd\u5c0f\u4e8e1") @Min(value=1L, message="\u6d3b\u52a8\u6a21\u7248ID\u4e0d\u80fd\u5c0f\u4e8e1") Long atId) {
        this.actionTemplateDas.logicDeleteById(atId);
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public void modifyActionTemplate(Long id, @Valid ActionTemplateReqDto dto) {
        ActionTemplateEo eo = BeanCopyUtil.copyProperties(ActionTemplateEo.class, dto, new String[0]);
        eo.setId(id);
        eo.setActionDefine(JSON.toJSONString((Object)dto.getActionDefineDto()));
        this.actionTemplateDas.updateSelective((BaseEo)eo);
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Long addActionTemplate(@Valid ActionTemplateReqDto dto) {
        ActionTemplateEo eo = BeanCopyUtil.copyProperties(ActionTemplateEo.class, dto, new String[0]);
        eo.setActionDefine(JSONObject.toJSONString((Object)dto.getActionDefineDto()));
        this.actionTemplateDas.insert((BaseEo)eo);
        return eo.getId();
    }

    @Override
    public Collection<ActionTemplateRespDto> queryByAcTemplateId(long acTemplateId) {
        Collection<TriggerEo> triggerEos = this.triggerService.queryByAcTemplateId(acTemplateId);
        List<Long> triggerIds = triggerEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        return this.queryByTriggerIds(triggerIds);
    }

    @Override
    public Collection<ActionTemplateRespDto> queryByTriggerIds(List<Long> triggerIds) {
        if (CollectionUtils.isEmpty(triggerIds)) {
            return Lists.newArrayList();
        }
        LinkedList result = Lists.newLinkedList();
        BatchOperationUtil.batchQuery(triggerIds, d -> {
            Collection eos = this.actionTemplateDas.selectByTriggerIds(d);
            result.addAll(BeanCopyUtil.copyCollections(eos, ActionTemplateRespDto.class, new String[0]));
        });
        return result;
    }

    @Override
    public ActionTemplateRespDto queryActionTemplateDetail(Long id) {
        this.checkBase(ServiceContext.getContext().getRequestInstanceId(), ServiceContext.getContext().getRequestTenantId());
        ActionTemplateEo actionTemplateEo = this.checkById(id, ServiceContext.getContext().getRequestInstanceId(), ServiceContext.getContext().getRequestTenantId());
        if (null == actionTemplateEo) {
            return null;
        }
        ActionTemplateRespDto actionTemplateRespDto = new ActionTemplateRespDto();
        CubeBeanUtils.copyProperties((Object)actionTemplateRespDto, (Object)actionTemplateEo, (String[])new String[0]);
        return actionTemplateRespDto;
    }

    @Override
    public List<ActionTemplateRespDto> queryActionTemplateList(ActionTemplateQueryReqDto actionTemplateQueryReqDto) {
        this.checkBase(ServiceContext.getContext().getRequestInstanceId(), ServiceContext.getContext().getRequestTenantId());
        ActionTemplateEo actionTemplateEo = ActionTemplateEo.newInstance();
        CubeBeanUtils.copyProperties((Object)actionTemplateEo, (Object)actionTemplateQueryReqDto, (String[])new String[0]);
        actionTemplateEo.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        actionTemplateEo.setTenantId(ServiceContext.getContext().getRequestTenantId());
        List actionTemplateEoList = this.actionTemplateDas.select((BaseEo)actionTemplateEo);
        ArrayList<ActionTemplateRespDto> actionTemplateRespDtoList = new ArrayList<ActionTemplateRespDto>();
        CubeBeanUtils.copyCollection(actionTemplateRespDtoList, (Collection)actionTemplateEoList, ActionTemplateRespDto.class);
        return actionTemplateRespDtoList;
    }

    @Override
    public PageInfo<ActionTemplateRespDto> queryActionTemplatePage(ActionTemplateQueryReqDto actionTemplateQueryReqDto, Integer pageNum, Integer pageSize) {
        this.checkBase(ServiceContext.getContext().getRequestInstanceId(), ServiceContext.getContext().getRequestTenantId());
        ActionTemplateEo actionTemplateEo = ActionTemplateEo.newInstance();
        CubeBeanUtils.copyProperties((Object)actionTemplateEo, (Object)actionTemplateQueryReqDto, (String[])new String[0]);
        actionTemplateEo.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        actionTemplateEo.setTenantId(ServiceContext.getContext().getRequestTenantId());
        PageInfo activityTemplateEoPageInfo = this.actionTemplateDas.selectPage((BaseEo)actionTemplateEo, pageNum, pageSize);
        ArrayList actionTemplateRespDtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)activityTemplateEoPageInfo.getList(), actionTemplateRespDtoList, ActionTemplateRespDto.class);
        activityTemplateEoPageInfo.setList(actionTemplateRespDtoList);
        return activityTemplateEoPageInfo;
    }

    private void checkBase(Long instanceId, Long tenantId) {
    }

    private ActionTemplateEo checkById(Long id, Long instanceId, Long tenantId) {
        ActionTemplateEo actionTemplateEo = (ActionTemplateEo)this.actionTemplateDas.selectByPrimaryKey(id);
        return actionTemplateEo;
    }
}

