/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityRuleItemReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityRuleItemRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.IActivityRuleItemService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ActivityRuleItemDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ActivityRuleItemEO;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ActivityRuleItemServiceImpl
implements IActivityRuleItemService {
    @Resource
    private ActivityRuleItemDas activityRuleItemDas;

    @Override
    public Long addActivityRuleItem(ActivityRuleItemReqDto addReqDto) {
        ActivityRuleItemEO activityRuleItemEo = new ActivityRuleItemEO();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)activityRuleItemEo);
        this.activityRuleItemDas.insert((BaseEo)activityRuleItemEo);
        return activityRuleItemEo.getId();
    }

    @Override
    public void modifyActivityRuleItem(ActivityRuleItemReqDto modifyReqDto) {
        ActivityRuleItemEO activityRuleItemEo = new ActivityRuleItemEO();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)activityRuleItemEo);
        this.activityRuleItemDas.updateSelective((BaseEo)activityRuleItemEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeActivityRuleItem(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.activityRuleItemDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ActivityRuleItemRespDto queryById(Long id) {
        ActivityRuleItemEO activityRuleItemEo = (ActivityRuleItemEO)this.activityRuleItemDas.selectByPrimaryKey(id);
        ActivityRuleItemRespDto activityRuleItemRespDto = new ActivityRuleItemRespDto();
        DtoHelper.eo2Dto((BaseEo)activityRuleItemEo, (BaseVo)activityRuleItemRespDto);
        return activityRuleItemRespDto;
    }

    @Override
    public PageInfo<ActivityRuleItemRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ActivityRuleItemReqDto activityRuleItemReqDto = (ActivityRuleItemReqDto)JSON.parseObject((String)filter, ActivityRuleItemReqDto.class);
        ActivityRuleItemEO activityRuleItemEo = new ActivityRuleItemEO();
        DtoHelper.dto2Eo((BaseVo)activityRuleItemReqDto, (BaseEo)activityRuleItemEo);
        PageInfo eoPageInfo = this.activityRuleItemDas.selectPage((BaseEo)activityRuleItemEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ActivityRuleItemRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public void insertBatchItem(Long activityId, List<ActivityRuleItemReqDto> activityRuleItems) {
        if (CollectionUtils.isEmpty(activityRuleItems)) {
            return;
        }
        ArrayList activityItemEos = Lists.newArrayList();
        for (ActivityRuleItemReqDto activityRuleItemReqDto : activityRuleItems) {
            ActivityRuleItemEO activityItemEo = ActivityRuleItemEO.newInstance();
            DtoHelper.dto2Eo((BaseVo)activityRuleItemReqDto, (BaseEo)activityItemEo);
            activityItemEo.setActivityId(activityId);
            activityItemEo.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
            activityItemEo.setTenantId(ServiceContext.getContext().getRequestTenantId());
            activityItemEos.add(activityItemEo);
        }
        if (!CollectionUtils.isEmpty((Collection)activityItemEos)) {
            this.activityRuleItemDas.insertBatch((List)activityItemEos);
        }
    }

    @Override
    public void deleteByActivityId(Long activityId) {
        ActivityRuleItemEO activityItemEo = ActivityRuleItemEO.newInstance();
        activityItemEo.setActivityId(activityId);
        this.activityRuleItemDas.delete((BaseEo)activityItemEo);
    }

    @Override
    public List<ActivityRuleItemRespDto> queryActivityRuleItemByActivityIds(List<Long> ids) {
        ArrayList dtos = Lists.newArrayList();
        ActivityRuleItemEO eo = new ActivityRuleItemEO();
        ArrayList sqlFilters = Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"activity_id", ids)});
        eo.setSqlFilters((List)sqlFilters);
        List activityRuleItemEos = this.activityRuleItemDas.select((BaseEo)eo);
        CubeBeanUtils.copyCollection((Collection)dtos, (Collection)activityRuleItemEos, ActivityRuleItemRespDto.class);
        return dtos;
    }
}

