/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.action;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.biz.account.api.IMemberCardApi;
import com.dtyunxi.yundt.cube.biz.account.api.dto.request.MemberCardAccountUpdateReqDto;
import com.dtyunxi.yundt.cube.biz.member.api.common.constants.enums.ModuleType;
import com.dtyunxi.yundt.cube.biz.member.api.common.util.CenterMemberCheckUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActionTemplateRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.EnableStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponCheckPointEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.InstallmentReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponChannelEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponTemplateExtQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore.vo.RechargeGiftConfigVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.promotion.service.IInstallmentService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.promotion.service.IMarketingPointService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ActionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ActivityEngineClient;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;

public class RechargeGiftAction
extends ActionTemplate {
    private static final Logger logger = LoggerFactory.getLogger(RechargeGiftAction.class);

    @Override
    public <T extends EngineParams> boolean execute(ActionTemplateRespDto actionTemplateRespDto, ActionRespDto actionRespDto, T context, Map<String, ?> map) {
        BigDecimal points;
        RechargeGiftConfigVo configVo = (RechargeGiftConfigVo)((Object)MapUtils.getObject((Map)context.getExtendsAttribute(), (Object)RechargeGiftConfigVo.class.getSimpleName()));
        BigDecimal amount = (BigDecimal)MapUtils.getObject((Map)context.getExtendsAttribute(), (Object)"rechargeGiftAmt");
        Map coupon = (Map)MapUtils.getObject((Map)context.getExtendsAttribute(), (Object)"returnCoupon");
        if (CenterMemberCheckUtil.isLoadModule((ModuleType)ModuleType.POINT) && (points = (BigDecimal)MapUtils.getObject((Map)context.getExtendsAttribute(), (Object)"returnPoints")) != null) {
            this.sendPoints(points, context, configVo);
        }
        if (amount != null) {
            this.sendAmount(amount, context, configVo);
        }
        if (MapUtils.isNotEmpty((Map)coupon)) {
            this.sendCoupon(coupon, context, configVo);
        }
        return true;
    }

    private <T extends EngineParams> void sendPoints(BigDecimal points, T context, RechargeGiftConfigVo configVo) {
        if (configVo.getMonthlyInstallment() == null || configVo.getMonthlyInstallment() == 0 && Objects.equals(configVo.getPostpone(), 0)) {
            ((IMarketingPointService)SpringBeanUtil.getBean(IMarketingPointService.class)).sendPointByEngineParams(context, points);
        } else {
            InstallmentReqDto reqDto = this.getInstallmentReqDto(context, points, configVo);
            ((IInstallmentService)SpringBeanUtil.getBean(IInstallmentService.class)).sendPoints(context.getUserId(), reqDto);
        }
    }

    private <T extends EngineParams> void sendCoupon(Map<String, Integer> coupon, T context, RechargeGiftConfigVo configVo) {
        coupon.forEach((templateCode, num) -> {
            CouponTemplateExtRespDto couponTemplate = ((ICouponTemplateExtQueryService)SpringBeanUtil.getBean(ICouponTemplateExtQueryService.class)).queryByCodeSimple((String)templateCode);
            if (null == couponTemplate) {
                throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u8981\u9886\u53d6\u7684\u4f18\u60e0\u5238\u4e0d\u5b58\u5728"}));
            }
            if (EnableStatusEnum.DISABLE.getKey().equals(couponTemplate.getCouponTemplateStatus())) {
                throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u4f18\u60e0\u5238\u5df2\u4e0d\u53ef\u9886\u53d6"}));
            }
            if (configVo.getMonthlyInstallment() == null || configVo.getMonthlyInstallment() == 0 && Objects.equals(configVo.getPostpone(), 0)) {
                EngineParams sendParam = new EngineParams();
                sendParam.setActivityId(couponTemplate.getActivityId().longValue());
                sendParam.setCouponTemplateId(couponTemplate.getId().longValue());
                sendParam.setUserId(context.getUserId());
                sendParam.addExtAttribute("activityCode", (Object)context.getExtendsAttribute().get("rechargeAccountFlowId").toString());
                sendParam.addExtAttribute("channel", (Object)CouponChannelEnum.RECHARGE_GIFT.getChannel());
                for (int i = 0; i < num; ++i) {
                    try {
                        ((ActivityEngineClient)SpringBeanUtil.getBean(ActivityEngineClient.class)).defineCheckpoint(CouponCheckPointEnum.RECEIVE_COUPON.toString()).execute(sendParam);
                        continue;
                    }
                    catch (Exception e) {
                        logger.warn("\u53d1\u9001\u4f18\u60e0\u5238\u5931\u8d25{}", (Object)JSON.toJSONString((Object)e));
                    }
                }
            } else {
                InstallmentReqDto reqDto = this.getInstallmentReqDto(context, BigDecimal.valueOf(num.intValue()), configVo);
                reqDto.setObjId(couponTemplate.getId());
                ((IInstallmentService)SpringBeanUtil.getBean(IInstallmentService.class)).sendCoupon(context.getUserId(), reqDto);
            }
        });
    }

    private InstallmentReqDto getInstallmentReqDto(EngineParams context, BigDecimal num, RechargeGiftConfigVo configVo) {
        InstallmentReqDto reqDto = new InstallmentReqDto();
        reqDto.setActivityId(Long.valueOf(context.getActivityId()));
        reqDto.setTotalNum(num);
        reqDto.setValidityDay(configVo.getRecycle());
        reqDto.setPostpone(configVo.getPostpone());
        reqDto.putExtension("channel", (Object)context.getProgramSrc());
        reqDto.putExtension("shopCode", (Object)context.getShopId());
        reqDto.putExtension("platCode", (Object)MapUtils.getString((Map)context.getExtendsAttribute(), (Object)"platCode"));
        reqDto.putExtension("channelSource", (Object)context.getProgramSrc());
        if (configVo.getMonthlyInstallment() != null) {
            if (configVo.getMonthlyInstallment() == 0) {
                reqDto.setMonthlyInstallment(Integer.valueOf(1));
            } else {
                reqDto.setMonthlyInstallment(configVo.getMonthlyInstallment());
            }
        } else {
            reqDto.setMonthlyInstallment(Integer.valueOf(1));
        }
        reqDto.setBusinessNo(context.getOrderCode());
        return reqDto;
    }

    private <T extends EngineParams> void sendAmount(BigDecimal amount, T context, RechargeGiftConfigVo configVo) {
        if (configVo.getMonthlyInstallment() == null || configVo.getMonthlyInstallment() == 0 && Objects.equals(configVo.getPostpone(), 0)) {
            MemberCardAccountUpdateReqDto reqDto = new MemberCardAccountUpdateReqDto();
            reqDto.setMemberId(Long.valueOf(context.getUserId()));
            reqDto.setTradeId(context.getOrderCode());
            reqDto.setGiveAmount(amount);
            ((IMemberCardApi)SpringBeanUtil.getBean(IMemberCardApi.class)).updateAmount(reqDto).getData();
        } else {
            InstallmentReqDto reqDto = this.getInstallmentReqDto(context, amount, configVo);
            ((IInstallmentService)SpringBeanUtil.getBean(IInstallmentService.class)).sendStoredValue(context.getUserId(), reqDto);
        }
    }
}

