/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.biz.member.api.basis.dto.response.MemberInfoDetailRespDto;
import com.dtyunxi.yundt.cube.biz.member.api.basis.query.IMemberInfoExtQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MarketingModuleHelper {
    private static Logger logger = LoggerFactory.getLogger(MarketingModuleHelper.class);
    @Autowired
    private IContext context;
    @Resource
    private ISellerQueryApi sellerQueryApi;
    @Resource
    private IUserQueryApi userQueryApi;
    @Autowired
    private IMemberInfoExtQueryApi memberInfoExtQueryApi;
    @Resource
    private ICacheService cacheService;
    private static final String ACTIVITY_CODE_NO = "ACTIVITY_CODE_NO";

    public Long getMemberIdByContext() {
        String key = "user_memberId" + this.context.userId();
        Long memberId = (Long)this.cacheService.getCache(key, Long.class);
        if (null == memberId) {
            MemberInfoDetailRespDto memberInfoDetailDto = (MemberInfoDetailRespDto)RestResponseHelper.extractData((RestResponse)this.memberInfoExtQueryApi.queryMemberInfoDetailByUserId(this.context.userId()));
            if (memberInfoDetailDto == null) {
                throw new BizException("\u4f1a\u5458\u8bb0\u5f55\u4e0d\u5b58\u5728");
            }
            memberId = memberInfoDetailDto.getId();
            this.cacheService.add(key, (Object)memberId);
        }
        return memberId;
    }

    public Long getMemberIdByUserId(Long userId) {
        MemberInfoDetailRespDto memberInfoDetailDto = (MemberInfoDetailRespDto)RestResponseHelper.extractData((RestResponse)this.memberInfoExtQueryApi.queryMemberInfoDetailByUserId(userId));
        logger.info("getMemberIdByContext \u4f1a\u5458\u8fd4\u56de\u7ed3\u679c ={}", JSON.toJSON((Object)memberInfoDetailDto));
        if (memberInfoDetailDto == null) {
            throw new BizException("\u4f1a\u5458\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        return memberInfoDetailDto.getId();
    }

    public String generateCode(String prefix) {
        StringBuilder code = new StringBuilder();
        String timeStr = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        code.append(prefix).append(timeStr);
        Long activityCodeNo = this.cacheService.incr(ACTIVITY_CODE_NO);
        Long model = activityCodeNo % 999L;
        if (model < 10L) {
            code.append("00").append(model);
        } else if (model < 100L) {
            code.append("0").append(model);
        } else {
            code.append(model);
        }
        int romNum = RandomUtils.nextInt((int)1, (int)999);
        if (romNum < 10) {
            code.append("00").append(romNum);
        } else if (romNum < 100) {
            code.append("0").append(romNum);
        } else {
            code.append(romNum);
        }
        return code.toString();
    }
}

