/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.mq.consumer;

import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityItemRuleService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.mq.vo.ItemStockMsg;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="MARKETING-ITEM-JOIN-NUM", topic="${imk.common.topic.activity.item:YUNDT_CUBE_CENTER_MARKETING_ITEM_RULE_TOPIC}")
public class ActivityItemJoinNumProcessor
implements IMessageProcessor<ItemStockMsg> {
    private static final Logger logger = LoggerFactory.getLogger(ActivityItemJoinNumProcessor.class);
    @Resource
    private IActivityItemRuleService activityItemService;
    @Autowired
    private ICacheService cacheService;

    public MessageResponse process(ItemStockMsg itemStockMsg) {
        String msgId = itemStockMsg.getSerial();
        logger.info("\u6536\u5230\u6d3b\u52a8\u53c2\u4e0e\u6b21\u6570\u89c4\u5219mq\u6d88\u606f\uff1amsgId:{} , body:{}\u3002\u5f00\u59cb\u5904\u7406", (Object)msgId, (Object)itemStockMsg);
        boolean add = this.cacheService.add(itemStockMsg.getSerial(), (Object)1, 300);
        if (!add) {
            logger.info("\u6d88\u606f\u5df2\u88ab\u5224\u5b9a\u4e3a\u91cd\u590d\u6d88\u606f\uff0c\u5ffd\u7565.msgId:{}", (Object)msgId);
            return MessageResponse.SUCCESS;
        }
        boolean result = this.activityItemService.increaseRealJoinNum(itemStockMsg.getAcId(), itemStockMsg.getId(), itemStockMsg.getShopId(), itemStockMsg.getNum(), itemStockMsg.getType());
        if (result) {
            return MessageResponse.SUCCESS;
        }
        logger.error("\u6d3b\u52a8\u5269\u4f59\u53c2\u4e0e\u6b21\u6570\u6263\u51cf\u5931\u8d25\uff0c\u7b49\u5f85\u4e0b\u6b21\u91cd\u8bd5\u3002");
        return MessageResponse.ERROR;
    }
}

