/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils;

import com.dtyunxi.cube.commons.exceptions.BizException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    public static final String pattern = "yyyy-MM-dd HH:mm:ss";
    private static Logger logger = LoggerFactory.getLogger(DateUtil.class);

    public static Date parseDate(String time) {
        return DateUtil.parseDate(time, pattern);
    }

    public static Date parseDate(String time, String pattern) {
        if (StringUtils.isBlank((CharSequence)time) || StringUtils.isEmpty((CharSequence)pattern)) {
            return null;
        }
        return DateUtil.parseTime(time, pattern);
    }

    public static Date checkAndParse(String time) {
        return DateUtil.checkAndParse(time, pattern);
    }

    public static Date checkAndParse(String time, String pattern) {
        if (StringUtils.isBlank((CharSequence)time)) {
            throw new BizException("\u7a7a\u5b57\u7b26");
        }
        return DateUtil.parseTime(time, pattern);
    }

    private static Date parseTime(String time, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        try {
            Date date = sdf.parse(time);
            return date;
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BizException("\u8f6c\u6362\u65f6\u95f4\u5f02\u5e38");
        }
    }

    public static String date2Cron(Date date) {
        String format = "ss mm HH dd MM ? yyyy";
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        String cron = null;
        if (date != null) {
            cron = sdf.format(date);
        }
        return cron;
    }

    public static Date getStartTimeOfDay(Date date) {
        if (date == null) {
            date = new Date();
        }
        date = DateUtils.setHours((Date)date, (int)0);
        date = DateUtils.setMinutes((Date)date, (int)0);
        date = DateUtils.setSeconds((Date)date, (int)0);
        date = DateUtils.setMilliseconds((Date)date, (int)0);
        return date;
    }

    public static Date getEndTimeOfDay(Date date) {
        if (date == null) {
            date = new Date();
        }
        date = DateUtils.setHours((Date)date, (int)23);
        date = DateUtils.setMinutes((Date)date, (int)59);
        date = DateUtils.setSeconds((Date)date, (int)59);
        date = DateUtils.setMilliseconds((Date)date, (int)0);
        return date;
    }
}

