/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponPackStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponPackReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponPackTemplateReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponPackRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponPackTemplateRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponPackService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponTemplateExtQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.coupon.das.CouponPackDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.coupon.das.CouponPackTemplateDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.coupon.mapper.CouponPackMapper;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.coupon.mapper.CouponPackTemplateMapper;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.CouponPackEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.CouponPackTemplateEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.StdCouponPackTemplateEo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CouponPackServiceImpl
implements ICouponPackService {
    private final Logger logger = LoggerFactory.getLogger(CouponPackServiceImpl.class);
    @Resource
    private CouponPackDas couponPackDas;
    @Resource
    private CouponPackMapper couponPackMapper;
    @Resource
    private CouponPackTemplateDas couponPackTemplateDas;
    @Resource
    private CouponPackTemplateMapper couponPackTemplateMapper;
    @Resource
    private ICouponTemplateExtQueryService couponTemplateExtQueryService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addCouponPack(CouponPackReqDto couponPackReqDto) {
        this.validPackName(couponPackReqDto.getCouponPackName(), null);
        List couponPackTemplateReqDtos = couponPackReqDto.getCouponPackTemplateReqDtos();
        if (CollectionUtils.isEmpty((Collection)couponPackTemplateReqDtos)) {
            throw new BizException("\u4f18\u60e0\u5238\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CouponPackEo couponPackEo = new CouponPackEo();
        DtoHelper.dto2Eo((BaseVo)couponPackReqDto, (BaseEo)couponPackEo);
        couponPackEo.setCouponPackCode(UUID.randomUUID().toString().replace("-", ""));
        couponPackEo.setCouponPackStatus(Integer.valueOf(1));
        couponPackEo.setTotalIssueQuantity(Integer.valueOf(couponPackTemplateReqDtos.size()));
        this.couponPackDas.insert((BaseEo)couponPackEo);
        List<CouponPackTemplateEo> eos = this.coverEoByList(couponPackTemplateReqDtos, couponPackEo);
        this.couponPackTemplateDas.insertBatch(eos);
        return couponPackEo.getId();
    }

    private List<CouponPackTemplateEo> coverEoByList(List<CouponPackTemplateReqDto> couponPackTemplateReqDtos, CouponPackEo couponPackEo) {
        ArrayList eos = Lists.newArrayList();
        couponPackTemplateReqDtos.stream().forEach(couponPackTemplateReqDto -> {
            CouponPackTemplateEo couponPackTemplateEo = new CouponPackTemplateEo();
            couponPackTemplateEo.setCouponPackId(couponPackEo.getId());
            couponPackTemplateEo.setCouponTemplateId(couponPackTemplateReqDto.getCouponTemplateId());
            couponPackTemplateEo.setCouponTemplateName(couponPackTemplateReqDto.getCouponTemplateName());
            eos.add(couponPackTemplateEo);
        });
        return eos;
    }

    private void validPackName(String couponPackName, Long id) {
        CouponPackEo queryEo = new CouponPackEo();
        queryEo.setCouponPackName(couponPackName);
        List select = this.couponPackDas.select((BaseEo)queryEo);
        if (CollectionUtils.isNotEmpty((Collection)select)) {
            if (null != id) {
                if (select.size() > 1 || !id.equals(((CouponPackEo)select.get(0)).getId())) {
                    throw new BizException("\u540d\u79f0\u91cd\u590d");
                }
            } else {
                throw new BizException("\u540d\u79f0\u91cd\u590d");
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void editCouponPack(Long id, CouponPackReqDto couponPackReqDto) {
        this.validPackName(couponPackReqDto.getCouponPackName(), id);
        CouponPackEo couponPackEo = (CouponPackEo)this.couponPackDas.selectByPrimaryKey(id);
        if (null == couponPackEo) {
            throw new BizException("\u5238\u5305\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (CouponPackStatusEnum.ACTIVATE.getStatus().equals(couponPackEo.getCouponPackStatus())) {
            throw new BizException("\u542f\u7528\u72b6\u6001\u4e0b\u4e0d\u53ef\u4fee\u6539");
        }
        CouponPackEo updateEo = new CouponPackEo();
        DtoHelper.dto2Eo((BaseVo)couponPackReqDto, (BaseEo)updateEo);
        if (CollectionUtils.isNotEmpty((Collection)couponPackReqDto.getCouponPackTemplateReqDtos())) {
            updateEo.setTotalIssueQuantity(Integer.valueOf(couponPackReqDto.getCouponPackTemplateReqDtos().size()));
            this.couponPackTemplateMapper.deletePackTemplateById(id);
            List<CouponPackTemplateEo> eos = this.coverEoByList(couponPackReqDto.getCouponPackTemplateReqDtos(), couponPackEo);
            this.couponPackTemplateDas.insertBatch(eos);
        }
        updateEo.setId(id);
        this.couponPackDas.updateSelective((BaseEo)updateEo);
    }

    @Override
    public PageInfo<CouponPackRespDto> queryPage(String packName, String packCode, Integer packType, String couponTemplateName, Integer status, Integer pageNum, Integer pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List eos = this.couponPackMapper.queryPage(packName, packCode, packType, couponTemplateName, status);
        PageInfo pageInfo = new PageInfo(eos);
        PageInfo result = new PageInfo();
        BeanUtils.copyProperties((Object)pageInfo, (Object)result, (String[])new String[]{"list"});
        ArrayList resultList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)pageInfo.getList(), (Collection)resultList, CouponPackRespDto.class);
        result.setList((List)resultList);
        return result;
    }

    @Override
    public CouponPackRespDto queryById(Long id) {
        CouponPackEo couponPackEo = (CouponPackEo)this.couponPackDas.selectByPrimaryKey(id);
        if (null == couponPackEo) {
            throw new BizException("\u5238\u5305\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        CouponPackRespDto couponPackRespDto = new CouponPackRespDto();
        DtoHelper.eo2Dto((BaseEo)couponPackEo, (BaseVo)couponPackRespDto);
        this.queryTemplatesByPackId(couponPackRespDto, id);
        return couponPackRespDto;
    }

    private void queryTemplatesByPackId(CouponPackRespDto couponPackRespDto, Long id) {
        List<Long> tempIds;
        List<CouponTemplateExtRespDto> couponTemplateExtRespDtos;
        CouponPackTemplateEo queryEo = new CouponPackTemplateEo();
        queryEo.setCouponPackId(id);
        List select = this.couponPackTemplateDas.select((BaseEo)queryEo);
        if (CollectionUtils.isNotEmpty((Collection)select) && CollectionUtils.isNotEmpty(couponTemplateExtRespDtos = this.couponTemplateExtQueryService.listByIds(tempIds = select.stream().map(StdCouponPackTemplateEo::getCouponTemplateId).collect(Collectors.toList())))) {
            List couponPackTemResult = couponPackRespDto.getCouponPackTemplateReqDtos();
            if (CollectionUtils.isEmpty((Collection)couponPackTemResult)) {
                couponPackTemResult = Lists.newArrayList();
            }
            for (CouponTemplateExtRespDto couponTemplateExtRespDto : couponTemplateExtRespDtos) {
                CouponPackTemplateRespDto couponPackTemplateRespDto = new CouponPackTemplateRespDto();
                DtoHelper.vo2Dto((BaseVo)couponTemplateExtRespDto, (BaseVo)couponPackTemplateRespDto);
                couponPackTemResult.add(couponPackTemplateRespDto);
            }
            couponPackRespDto.setCouponPackTemplateReqDtos(couponPackTemResult);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteById(Long id) {
        this.couponPackTemplateMapper.deletePackTemplateById(id);
        this.couponPackDas.deleteById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateStatusById(Long id, Integer status) {
        if (status == null) {
            throw new BizException("\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CouponPackEo updateEo = new CouponPackEo();
        updateEo.setId(id);
        updateEo.setCouponPackStatus(status);
        this.couponPackDas.updateSelective((BaseEo)updateEo);
    }
}

