/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponCategoryEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponMoneyOffDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ActivityCoupon;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.Param;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ConditionTemplate;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouponMoneyOffCondition
extends ConditionTemplate {
    private static Logger logger = LoggerFactory.getLogger(CouponMoneyOffCondition.class);
    public static final String CONDNTION = "CouponMoneyOffCondition.condition";
    public static final String TYPE = "CouponMoneyOffCondition.type";

    @Override
    public <T extends EngineParams> boolean execute(TemplateDefine define, ConditionRespDto conditionRespDto, T params, Map<String, ?> activityParams) {
        logger.info("\u4f18\u60e0\u5238\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(params));
        Param typeParam = define.getParam(TYPE);
        Param conditionParam = define.getParam(CONDNTION);
        if (null == typeParam || null == conditionParam) {
            throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u4f18\u60e0\u5238\u6ee1\u51cf\u6ee1\u6298\u6761\u4ef6\u672a\u914d\u7f6e"}));
        }
        Integer catalogType = (Integer)ConditionTemplate.converter(activityParams.get(TYPE), typeParam, define.getLoadClass());
        CouponMoneyOffDto moneyOffConditionVo = (CouponMoneyOffDto)ConditionTemplate.converter(activityParams.get(CONDNTION), conditionParam, define.getLoadClass());
        boolean result = false;
        ActivityCoupon activityCoupon = params.getCouponByActivityId(Long.valueOf(params.getActivityId()));
        if (null != activityCoupon && CollectionUtils.isNotEmpty((Collection)activityCoupon.getItems())) {
            BigDecimal orderAmount = activityCoupon.getItems().stream().map(itemVo -> itemVo.getPrice().multiply(new BigDecimal(itemVo.getNum()))).reduce(BigDecimal.ZERO, BigDecimal::add);
            result = CouponMoneyOffCondition.judgeMoneyOffCondition(orderAmount, catalogType, moneyOffConditionVo);
        }
        if (!result) {
            throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u4f18\u60e0\u5238\u4e0d\u6ee1\u8db3\u4f7f\u7528\u91d1\u989d\u6761\u4ef6"}));
        }
        return result;
    }

    public static boolean judgeMoneyOffCondition(BigDecimal orderAmount, Integer catalogType, CouponMoneyOffDto couponMoneyOffDto) {
        if (orderAmount == null) {
            throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u4e0b\u5355\u672a\u4f20\u9012\u8ba2\u5355\u91d1\u989d\u8fdb\u884c\u4f18\u60e0\u5238\u5224\u65ad"}));
        }
        if (couponMoneyOffDto == null) {
            throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u4f18\u60e0\u5238\u6a21\u677f\u5c1a\u672a\u914d\u7f6e\u4f18\u60e0\u91d1\u989d\u4fe1\u606f"}));
        }
        BigDecimal discountValue = couponMoneyOffDto.getDiscountValue();
        if (CouponCategoryEnum.DISCOUNT.getCategory().equals(catalogType)) {
            discountValue = orderAmount.multiply(couponMoneyOffDto.getDiscountValue());
        }
        Optional.ofNullable(discountValue).orElseThrow(() -> new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u6ee1\u51cf\uff0c\u6ee1\u6298\u5238\u6298\u6263\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a"})));
        boolean result = false;
        if (couponMoneyOffDto.getLimitAmount() == null && couponMoneyOffDto.getMaxDiscountValue() == null) {
            result = true;
        } else if (couponMoneyOffDto.getLimitAmount() != null && couponMoneyOffDto.getMaxDiscountValue() != null) {
            if (orderAmount.compareTo(couponMoneyOffDto.getLimitAmount()) >= 0 && couponMoneyOffDto.getMaxDiscountValue().compareTo(discountValue) >= 0) {
                result = true;
            }
        } else if (couponMoneyOffDto.getLimitAmount() != null) {
            if (orderAmount.compareTo(couponMoneyOffDto.getLimitAmount()) >= 0) {
                result = true;
            }
        } else if (couponMoneyOffDto.getMaxDiscountValue() != null && couponMoneyOffDto.getMaxDiscountValue().compareTo(discountValue) >= 0) {
            result = true;
        }
        return result;
    }

    public static CouponMoneyOffDto parseParams(String conditionParams) {
        JSONObject jsonObject;
        if (StringUtils.isNotEmpty((CharSequence)conditionParams) && (jsonObject = JSON.parseObject((String)conditionParams)).containsKey((Object)CONDNTION)) {
            CouponMoneyOffDto result = (CouponMoneyOffDto)jsonObject.getObject(CONDNTION, CouponMoneyOffDto.class);
            return result;
        }
        return null;
    }
}

