/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.promotion.apiimpl.query;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityExtDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityListRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.ConditionDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.PromotionBaseInfoDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.PromotionQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.response.PromotionInfoRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.response.PromotionListRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.service.query.IPromotionQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.IActivityExtService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.query.IActivityExtQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.converter.promotion.condition.ActivityFactory;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityService;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="promotionQueryApi")
public class PromotionQueryApiImpl
implements IPromotionQueryApi {
    @Resource
    private IActivityExtService activityExtService;
    @Autowired
    private IActivityService activityService;
    @Autowired
    private IActivityExtQueryService activityExtQueryService;

    public RestResponse<PageInfo<PromotionListRespDto>> queryByPage(PromotionQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        ActivityExtDto activityDto = new ActivityExtDto();
        BeanUtils.copyProperties((Object)reqDto, (Object)activityDto);
        PageInfo<ActivityListRespDto> data = this.activityExtQueryService.queryActivityPage(activityDto, pageNum, pageSize);
        PageInfo resultPage = new PageInfo();
        if (data != null && CollectionUtils.isNotEmpty((Collection)data.getList())) {
            BeanUtils.copyProperties(data, (Object)resultPage, (String[])new String[]{"list"});
            ArrayList resultList = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)resultList, (Collection)data.getList(), PromotionListRespDto.class);
            resultList.forEach(dto -> {
                dto.setActivityType(ActivityType.getByType((Long)dto.getActivityTemplateId()));
                dto.setUpdateAcc(dto.getUpdatePerson());
                dto.setStartAcc(dto.getAuditPerson());
            });
            resultPage.setList((List)resultList);
        }
        return new RestResponse((Object)resultPage);
    }

    public RestResponse<PromotionInfoRespDto> queryDetail(Long activityId) {
        PromotionInfoRespDto resp = new PromotionInfoRespDto();
        ActivityRespDto data = this.activityService.getActivity(activityId);
        if (data == null) {
            return null;
        }
        this.fillBaseInfo(data, resp);
        this.fillCondition(data, resp);
        return new RestResponse((Object)resp);
    }

    private void fillCondition(ActivityRespDto data, PromotionInfoRespDto resp) {
        ActivityType activityType = ActivityType.getByType((Long)data.getActivityTemplateId());
        if (activityType == null) {
            return;
        }
        ArrayList ruleList = Lists.newArrayList();
        ActivityFactory.getActivityTemplate(activityType).forEach(e -> data.getConditionDtos().forEach(eo -> {
            List<ConditionDto> result = e.changeToRules((ConditionRespDto)eo, resp);
            if (CollectionUtils.isNotEmpty(result)) {
                ruleList.addAll(result);
            }
        }));
        resp.setRuleList((List)ruleList);
    }

    private void fillBaseInfo(ActivityRespDto data, PromotionInfoRespDto resp) {
        PromotionBaseInfoDto baseInfo = new PromotionBaseInfoDto();
        CubeBeanUtils.copyProperties((Object)baseInfo, (Object)data, (String[])new String[0]);
        baseInfo.setDesc(data.getRemark());
        ActivityType activityType = ActivityType.getByType((Long)data.getActivityTemplateId());
        baseInfo.setActivityType(activityType);
        Map extFields = data.getExtFields();
        baseInfo.setMutex(MapUtils.getIntValue((Map)extFields, (Object)"mutexLevel"));
        baseInfo.setPromotionPlainId(MapUtils.getLong((Map)extFields, (Object)"plainId"));
        baseInfo.setPromotionType(MapUtils.getString((Map)extFields, (Object)"activityItemRange"));
        baseInfo.setActivityCode(MapUtils.getString((Map)extFields, (Object)"activityCode"));
        baseInfo.setO2oChannel(MapUtils.getString((Map)extFields, (Object)"o2oChannel"));
        baseInfo.setExtFields(null);
        resp.setInfoDto(baseInfo);
    }
}

