/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.condition.common;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ConditionReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponTemplateShopTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateShopDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common.BaseActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.PromotionActivityItemDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.exchange.ExchangeActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.fullreduction.FullReductionActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.group.GroupActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.group.GroupActivityItemDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.returngift.ReturnGiftActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.seckill.SeckillActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.timediscount.TimeDiscountActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.condition.AbstractBaseTemplate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class ShopCondition
extends AbstractBaseTemplate {
    @Override
    protected <T extends BaseActivityDto> void parse(ConditionRespDto conditionRespDto, T t) {
    }

    @Override
    public long getConditionTemplateId() {
        return 1196944771412880269L;
    }

    @Override
    public long getRuleId() {
        return 0L;
    }

    @Override
    public boolean support(ActivityType type) {
        return true;
    }

    @Override
    public <T extends BaseActivityDto> ConditionReqDto convertToCondition(T t) {
        GroupActivityDto activityDto;
        ConditionReqDto conditionReqDto = this.getConditionReqDto();
        List shopIds = null;
        if (t instanceof GroupActivityDto) {
            activityDto = (GroupActivityDto)t;
            shopIds = activityDto.getItems().stream().map(GroupActivityItemDto::getShopId).distinct().collect(Collectors.toList());
        } else if (t instanceof FullReductionActivityDto) {
            activityDto = (FullReductionActivityDto)t;
            if (CollectionUtils.isNotEmpty((Collection)activityDto.getActivityItems())) {
                shopIds = activityDto.getActivityItems().stream().map(PromotionActivityItemDto::getShopId).distinct().collect(Collectors.toList());
            }
        } else if (t instanceof TimeDiscountActivityDto) {
            activityDto = (TimeDiscountActivityDto)t;
            shopIds = activityDto.getActivityItems().stream().map(PromotionActivityItemDto::getShopId).distinct().collect(Collectors.toList());
        } else if (t instanceof SeckillActivityDto) {
            activityDto = (SeckillActivityDto)t;
            shopIds = activityDto.getActivityItems().stream().map(GroupActivityItemDto::getShopId).distinct().collect(Collectors.toList());
        } else if (t instanceof ReturnGiftActivityDto) {
            activityDto = (ReturnGiftActivityDto)t;
            shopIds = activityDto.getActivityItems().stream().map(PromotionActivityItemDto::getShopId).collect(Collectors.toList());
        } else if (t instanceof ExchangeActivityDto) {
            activityDto = (ExchangeActivityDto)t;
            shopIds = activityDto.getActivityItems().stream().map(PromotionActivityItemDto::getShopId).collect(Collectors.toList());
        }
        List<Object> shopDtos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(shopIds)) {
            shopDtos = shopIds.stream().map(shopId -> {
                CouponTemplateShopDto shop = new CouponTemplateShopDto();
                shop.setShopCode(shopId.toString());
                shop.setEffective(Boolean.valueOf(true));
                return shop;
            }).collect(Collectors.toList());
        }
        HashMap shopConditionParam = Maps.newHashMap();
        shopConditionParam.put("CouponShopCondition.shopIds", shopDtos);
        Integer shopRangeType = CollectionUtils.isEmpty(shopIds) ? CouponTemplateShopTypeEnum.ALL_SHOP.getType() : CouponTemplateShopTypeEnum.INCLUDE_PART_SHOP.getType();
        shopConditionParam.put("CouponShopCondition.shopRangeType", shopRangeType);
        conditionReqDto.setConditionParams(JSON.toJSONString((Object)shopConditionParam));
        return conditionReqDto;
    }
}

