/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityItemReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.EnableStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common.BaseActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.seckill.SeckillActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.ActivityItemTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.IItem;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.ISeckillActivity;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.condition.ActivityFactory;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.condition.ConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.impl.AbstractActivityService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.impl.MarketingModuleHelper;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class SeckillActivityImpl
extends AbstractActivityService
implements ISeckillActivity {
    @Resource
    private IContext context;
    @Resource(name="activityQueryApiImpl")
    private IActivityQueryApi activityQueryApi;
    @Resource
    private MarketingModuleHelper marketingModuleHelper;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private IItem itemService;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;

    @Override
    public Long add(SeckillActivityDto activityReqDto) {
        this.validate(activityReqDto);
        activityReqDto.setActivityCode(this.marketingModuleHelper.generateCode("MS"));
        return this.addActivity(activityReqDto);
    }

    private void validate(SeckillActivityDto activityReqDto) {
        if (null == activityReqDto.getJoinNum()) {
            activityReqDto.setJoinNum(Integer.valueOf(Integer.MAX_VALUE));
        }
        if (activityReqDto.getJoinNum() < 1) {
            throw new BizException("\u6bcf\u4eba\u53c2\u4e0e\u6b21\u6570\u9700\u8981\u5927\u4e8e0");
        }
        if (activityReqDto.getValidPayTime() != null && activityReqDto.getValidPayTime() < 1) {
            throw new BizException("\u652f\u4ed8\u6709\u6548\u65f6\u95f4\u9700\u8981\u5927\u4e8e0");
        }
        if (CollectionUtils.isEmpty((Collection)activityReqDto.getActivityItems())) {
            throw new BizException("\u6d3b\u52a8\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        activityReqDto.getActivityItems().forEach(itemDto -> {
            if (null == itemDto.getPurchaseQuantityLimitSingle()) {
                throw new BizException("\u6bcf\u4eba\u6bcf\u6b21\u9650\u8d2d\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (itemDto.getPurchaseQuantityLimitSingle() < 1) {
                throw new BizException("\u6bcf\u4eba\u6bcf\u6b21\u9650\u8d2d\u6570\u9700\u8981\u5927\u4e8e0");
            }
            if (itemDto.getShopId() == null) {
                throw new BizException("\u5546\u54c1\u5e97\u94faID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            itemDto.getSkus().forEach(sku -> {
                BigDecimal sellPrice = this.itemService.queryItemPrice(itemDto.getShopId(), itemDto.getItemId(), sku.getSkuId());
                if (null == sku.getGroupPrice()) {
                    throw new BizException("\u5546\u54c1\u4fc3\u9500\u6d3b\u52a8\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (sku.getGroupPrice().compareTo(BigDecimal.ZERO) == -1) {
                    throw new BizException("\u5546\u54c1\u4fc3\u9500\u6d3b\u52a8\u4ef7\u683c\u4e0d\u80fd\u5c0f\u4e8e0");
                }
                if (null == sellPrice || sellPrice.compareTo(sku.getGroupPrice()) == -1) {
                    throw new BizException("\u4fc3\u9500\u4ef7\u683c\u4e0d\u80fd\u5927\u4e8e\u5546\u54c1\u552e\u4ef7");
                }
                if (sku.getActivityStock() == null || sku.getActivityStock() < 1L) {
                    throw new BizException("\u5546\u54c1\u6d3b\u52a8\u5e93\u5b58\u9700\u8981\u5927\u4e8e0");
                }
                if (itemDto.getPurchaseQuantityLimitSingle() != null && (long)itemDto.getPurchaseQuantityLimitSingle().intValue() > sku.getActivityStock()) {
                    throw new BizException("\u6bcf\u4eba\u9650\u8d2d\u6570\u91cf\u4e0d\u80fd\u8d85\u51fa\u6d3b\u52a8\u5e93\u5b58");
                }
            });
        });
    }

    @Override
    protected <T extends BaseActivityDto> List<ActivityItemReqDto> getActivityItems(T activityReqDto) {
        SeckillActivityDto activityDto = (SeckillActivityDto)activityReqDto;
        ArrayList activityItems = Lists.newArrayList();
        activityDto.getActivityItems().forEach(itemDto -> itemDto.getSkus().forEach(skuDto -> {
            ActivityItemReqDto activityItemReqDto = new ActivityItemReqDto();
            activityItemReqDto.setItemId(skuDto.getItemId());
            activityItemReqDto.setItemName(itemDto.getItemName());
            activityItemReqDto.setSkuId(skuDto.getSkuId());
            activityItemReqDto.setInstanceId(this.context.instanceId());
            activityItemReqDto.setTenantId(this.context.tenantId());
            activityItemReqDto.setItemType(ActivityItemTypeEnum.ITEM.getKey());
            activityItemReqDto.setStatus(EnableStatusEnum.ENABLE);
            activityItemReqDto.setRemainingStock(skuDto.getActivityStock());
            activityItemReqDto.setOriginalStock(skuDto.getActivityStock());
            activityItemReqDto.setActivityPrice(skuDto.getGroupPrice());
            activityItemReqDto.setShopId(itemDto.getShopId());
            activityItems.add(activityItemReqDto);
        }));
        return activityItems;
    }

    @Override
    public SeckillActivityDto getDetail(Long id) {
        ActivityRespDto activityRespDto = (ActivityRespDto)this.activityQueryApi.queryActivityFatDetail(id.longValue()).getData();
        if (activityRespDto == null) {
            return null;
        }
        SeckillActivityDto seckillActivityDto = new SeckillActivityDto();
        CubeBeanUtils.copyProperties((Object)seckillActivityDto, (Object)activityRespDto, (String[])new String[0]);
        List<ConditionTemplate> templateList = ActivityFactory.getActivityTemplate(ActivityType.SECKILL_ACTIVITY);
        templateList.forEach(conditionTemplate -> conditionTemplate.parseCondition(activityRespDto.getConditionDtos(), seckillActivityDto));
        seckillActivityDto.setActivityType(ActivityType.getByType((Long)activityRespDto.getActivityTemplateId()));
        seckillActivityDto.setOrganizationIds((List)RestResponseHelper.extractData((RestResponse)this.organizationQueryApi.queryAllSuperiorOrgIdList()));
        return seckillActivityDto;
    }
}

