/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.PolicyRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IPolicyConfigQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.Checkpoint;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ActivityEngineClient {
    private static final Logger logger = LoggerFactory.getLogger(ActivityEngineClient.class);
    @Resource
    private IPolicyConfigQueryApi policyConfigQueryImpl;
    @Resource
    private IActivityQueryApi activityQueryApiImpl;
    @Autowired
    private ICacheService cacheService;
    private Map<String, Checkpoint> checkpointMap = new ConcurrentHashMap<String, Checkpoint>();
    private Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Checkpoint defineCheckpoint(String checkpointCode) {
        if (this.checkpointMap.containsKey(checkpointCode)) {
            return this.checkpointMap.get(checkpointCode);
        }
        Checkpoint checkpoint = null;
        Object object = this.lock;
        synchronized (object) {
            if (!this.checkpointMap.containsKey(checkpointCode)) {
                checkpoint = this.initCheckpoint(checkpointCode);
                this.checkpointMap.put(checkpointCode, checkpoint);
            }
        }
        if (checkpoint == null) {
            checkpoint = this.checkpointMap.get(checkpointCode);
        }
        return checkpoint;
    }

    public Checkpoint initCheckpoint(String checkpointCode) {
        RestResponse restResponse = this.policyConfigQueryImpl.queryPoliciesByCheckpoint(checkpointCode);
        logger.info("\u83b7\u53d6\u5230{}\uff0c\u5bf9\u5e94\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)checkpointCode, (Object)JSON.toJSONString((Object)restResponse.getData()));
        this.validatePolicy(checkpointCode, (List)restResponse.getData());
        return new Checkpoint(checkpointCode, (List)restResponse.getData(), this.activityQueryApiImpl, this.cacheService);
    }

    private void validatePolicy(String checkpointCode, List<PolicyRespDto> policyRespDtos) {
        if (CollectionUtils.isEmpty(policyRespDtos)) {
            throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u68c0\u67e5\u70b9{}\u672a\u914d\u7f6e\u7b56\u7565"}).format(new String[]{checkpointCode}));
        }
        policyRespDtos.forEach(policyDto -> {
            if (CollectionUtils.isEmpty((Collection)policyDto.getTriggerList())) {
                throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u68c0\u67e5\u70b9{}\u7b56\u7565{}\u672a\u914d\u7f6e\u89e6\u53d1\u5668"}).format(new String[]{checkpointCode, String.valueOf(policyDto.getId())}));
            }
            policyDto.getTriggerList().forEach(triggerDto -> {
                List ruleDtoList = triggerDto.getRuleList();
                if (CollectionUtils.isEmpty((Collection)ruleDtoList)) {
                    throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u68c0\u67e5\u70b9{}\u7b56\u7565{}\u89e6\u53d1\u5668{}\u672a\u914d\u7f6e\u89c4\u5219"}).format(new String[]{checkpointCode, String.valueOf(policyDto.getId()), String.valueOf(triggerDto.getId())}));
                }
                ruleDtoList.forEach(ruleDto -> {
                    if (CollectionUtils.isEmpty((Collection)ruleDto.getConditionTemplateList())) {
                        throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u68c0\u67e5\u70b9{}\u7b56\u7565{}\u89e6\u53d1\u5668{}\u89c4\u5219{}\u672a\u914d\u7f6e\u6761\u4ef6\u6a21\u677f"}).format(new String[]{checkpointCode, String.valueOf(policyDto.getId()), String.valueOf(triggerDto.getId()), String.valueOf(ruleDto.getId())}));
                    }
                });
                if (CollectionUtils.isEmpty((Collection)triggerDto.getActionTemplates())) {
                    throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u68c0\u67e5\u70b9{}\u7b56\u7565{}\u89e6\u53d1\u5668{}\u672a\u914d\u7f6e\u52a8\u4f5c"}).format(new String[]{checkpointCode, String.valueOf(policyDto.getId()), String.valueOf(triggerDto.getId())}));
                }
            });
        });
    }
}

