/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.biz.commons.dto.event.CouponEventDataDto;
import com.dtyunxi.cube.biz.commons.dto.event.EventMarketingExecDto;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponSendRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.utils.MyDateUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.IEventPoolExtService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponEventService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.query.ICouponExtQueryService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

@RefreshScope
@Service
public class CouponEventServiceImpl
implements ICouponEventService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ICommonsMqService commonsMqService;
    @Autowired
    private ICouponExtQueryService couponExtQueryService;
    @Autowired
    private IEventPoolExtService eventPoolExtService;
    @Value(value="${delay.time.to.trigger.event.mq:10:00:00}")
    private String delayTime;

    @Override
    public void asyncProcessReceiveEvent(Long memberId, Long couponTemplateId, CouponSendRespDto couponSendRespDto) {
        this.logger.info("\u5f02\u6b65\u5904\u7406\u4f18\u60e0\u5238\u9886\u53d6\u4e8b\u4ef6, couponSendRespDto={}", (Object)JSON.toJSONString((Object)couponSendRespDto));
        try {
            EventMarketingExecDto eventMarketingExecDto = this.createEventData(couponTemplateId, memberId, couponSendRespDto.getCouponCode(), couponSendRespDto.getCouponName(), "into_coupon");
            this.eventPoolExtService.sendEventMarketingPool(eventMarketingExecDto);
            this.logger.info("\u4f18\u60e0\u5238\u9886\u53d6\u4e8b\u4ef6 ---> \u7ed3\u675f\u53d1\u9001\u4e8b\u4ef6\u6c60\uff1a\u4f18\u60e0\u5238\u9886\u53d6\u4e8b\u4ef6");
        }
        catch (Exception e) {
            this.logger.error("\u5f02\u6b65\u5904\u7406\u4f18\u60e0\u5238\u9886\u53d6\u4e8b\u4ef6\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    @Override
    public void asyncProcessUseEvent(Long memberId, Long couponTemplateId, CouponExtRespDto couponExtRespDto) {
        try {
            if (null != couponExtRespDto) {
                EventMarketingExecDto eventMarketingExecDto = this.createEventData(couponTemplateId, memberId, couponExtRespDto.getCouponCode(), couponExtRespDto.getCouponName(), "use_coupon");
                eventMarketingExecDto.setInstanceId(couponExtRespDto.getInstanceId());
                eventMarketingExecDto.setTenantId(couponExtRespDto.getTenantId());
                this.eventPoolExtService.sendEventMarketingPool(eventMarketingExecDto);
                this.logger.info("\u4f18\u60e0\u5238\u6838\u9500\u4e8b\u4ef6 ---> \u7ed3\u675f\u53d1\u9001\u4e8b\u4ef6\u6c60\uff1a\u4f18\u60e0\u5238\u6838\u9500\u4e8b\u4ef6");
            }
        }
        catch (Exception e) {
            this.logger.error("\u5f02\u6b65\u5904\u7406\u4f18\u60e0\u5238\u6838\u9500\u4e8b\u4ef6\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    private EventMarketingExecDto createEventData(long couponTemplateId, long memberId, String code, String name, String eventCode) {
        EventMarketingExecDto eventMarketingExecDto = EventMarketingExecDto.init((String)eventCode, (Long)memberId);
        CouponEventDataDto couponEventDataDto = new CouponEventDataDto();
        couponEventDataDto.setId(Long.valueOf(couponTemplateId));
        couponEventDataDto.setCode(code);
        couponEventDataDto.setName(name);
        eventMarketingExecDto.getEventData().setCoupon(couponEventDataDto);
        return eventMarketingExecDto;
    }

    public static void main(String[] args) {
        String time = "21:50:00";
        long delaySecond = 0L;
        if (time == null) {
            time = "08:00:00";
        } else if (time.length() == 5) {
            time = time + ":00";
        }
        System.out.println(MyDateUtil.getTimeMillis((String)time) - MyDateUtil.getCurrentTimeMillis2Zero());
    }

    @Override
    public void processExpireEvent(Long memberId, Long couponTemplateId, CouponExtRespDto couponExtRespDto, Long eventRuleId) {
        try {
            if (null != couponExtRespDto) {
                EventMarketingExecDto eventMarketingExecDto = this.createEventData(couponTemplateId, memberId, couponExtRespDto.getCouponCode(), couponExtRespDto.getCouponName(), "ex_coupon");
                eventMarketingExecDto.getExtFields().put("eventRuleId", eventRuleId);
                this.eventPoolExtService.sendEventMarketingPool(eventMarketingExecDto);
                this.logger.info("\u4f18\u60e0\u5238\u8fc7\u671f\u4e8b\u4ef6 ---> \u7ed3\u675f\u53d1\u9001\u4e8b\u4ef6\u6c60\uff1a\u4f18\u60e0\u5238\u8fc7\u671f\u4e8b\u4ef6");
            }
        }
        catch (Exception e) {
            this.logger.error("\u5f02\u6b65\u5904\u7406\u4f18\u60e0\u5238\u8fc7\u671f\u4e8b\u4ef6\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    @Override
    public void processExpireEventByDavinci(CouponExtRespDto couponExtRespDto) {
    }
}

