/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.promotion.service.impl;

import com.dtyunxi.cube.commons.exceptions.SystemException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.constants.enums.PresentReferEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.constants.enums.PresentTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.PresentInfoDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.PresentReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizExceptionCodeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.promotion.service.IPresentService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.promotion.das.PresentDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.promotion.das.PresentsInfoDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.promotion.PresentEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.promotion.PresentsInfoEo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="presentService")
public class PresentServiceImpl
implements IPresentService {
    @Resource
    private PresentDas presentDas;
    @Resource
    private PresentsInfoDas presentsInfoDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addPresentGroup(PresentReqDto reqDto) {
        if (CollectionUtils.isNotEmpty((Collection)this.presentsInfoDas.queryByName(reqDto.getGroupName()))) {
            throw new SystemException(ProBizExceptionCodeEnum.PRESENT_NAME_REPEAT.getCode(), ProBizExceptionCodeEnum.PRESENT_NAME_REPEAT.getMsg());
        }
        List presentList = reqDto.getPresentList();
        PresentsInfoEo forInsert = new PresentsInfoEo();
        forInsert.setName(reqDto.getGroupName());
        forInsert.setType(reqDto.getPresentType().getType());
        if (reqDto.getReference() != null) {
            forInsert.setReference(reqDto.getReference().getType());
        } else {
            forInsert.setReference(PresentReferEnum.NOT_REFER.getType());
        }
        if (presentList != null) {
            forInsert.setNum(Integer.valueOf(presentList.size()));
        }
        forInsert.setUpdatePerson("");
        this.presentsInfoDas.insert((BaseEo)forInsert);
        Long infoId = forInsert.getId();
        if (CollectionUtils.isNotEmpty((Collection)presentList)) {
            ArrayList insertBatch = Lists.newArrayList();
            presentList.forEach(present -> {
                PresentEo presentEo = new PresentEo();
                presentEo.setUpdatePerson("");
                presentEo.setPresentsInfoId(infoId);
                presentEo.setCode(present.getCode());
                presentEo.setName(present.getName());
                presentEo.setObjId(present.getObjId());
                if (Objects.equals(PresentTypeEnum.ITEM.getType(), reqDto.getPresentType().getType())) {
                    presentEo.setStock(present.getStock());
                }
                presentEo.setNum(present.getNum());
                insertBatch.add(presentEo);
            });
            this.presentDas.insertBatch((List)insertBatch);
        }
        return infoId;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyPresentGroup(Long groupId, PresentReqDto reqDto) {
        boolean repeat;
        PresentsInfoEo sourceGroup = (PresentsInfoEo)this.presentsInfoDas.selectByPrimaryKey(groupId);
        if (sourceGroup == null) {
            throw new ProBizException(ProBizExceptionCodeEnum.PRESENT_RECORD_NOT_EXIST.getMsg());
        }
        List sourceInfoList = this.presentsInfoDas.queryByName(reqDto.getGroupName());
        if (CollectionUtils.isNotEmpty((Collection)sourceInfoList) && (repeat = sourceInfoList.stream().anyMatch(a -> !Objects.equals(a.getId(), groupId)))) {
            throw new SystemException(ProBizExceptionCodeEnum.PRESENT_NAME_REPEAT.getCode(), ProBizExceptionCodeEnum.PRESENT_NAME_REPEAT.getMsg());
        }
        List presentList = reqDto.getPresentList();
        this.updatePresent(groupId, presentList);
        PresentsInfoEo forUpd = new PresentsInfoEo();
        forUpd.setId(groupId);
        forUpd.setName(reqDto.getGroupName());
        forUpd.setNum(this.presentDas.getPresentNum(groupId));
        this.presentsInfoDas.updateSelective((BaseEo)forUpd);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deletePresentGroup(Long groupId, boolean checkRefer) {
        if (groupId == null) {
            return;
        }
        PresentsInfoEo presentsInfoEo = (PresentsInfoEo)this.presentsInfoDas.selectByPrimaryKey(groupId);
        if (presentsInfoEo == null) {
            return;
        }
        if (checkRefer && Objects.equals(presentsInfoEo.getReference(), PresentReferEnum.REFER.getType())) {
            throw new SystemException(ProBizExceptionCodeEnum.PRESENT_REFER.getCode(), ProBizExceptionCodeEnum.PRESENT_REFER.getMsg());
        }
        this.presentsInfoDas.logicDeleteById(groupId);
        PresentEo presentEo = new PresentEo();
        presentEo.setPresentsInfoId(groupId);
        this.presentDas.logicDelete((BaseEo)presentEo);
    }

    @Override
    public void refer(Long groupId, PresentReferEnum refer) {
        PresentsInfoEo presentsInfoEo = (PresentsInfoEo)this.presentsInfoDas.selectByPrimaryKey(groupId);
        if (presentsInfoEo != null) {
            PresentsInfoEo forUpd = new PresentsInfoEo();
            forUpd.setId(groupId);
            forUpd.setReference(refer.getType());
            this.presentsInfoDas.updateSelective((BaseEo)forUpd);
        }
    }

    private void updatePresent(Long groupId, List<PresentInfoDto> targetList) {
        ArrayList dtoIds = Lists.newArrayList();
        targetList.forEach(a -> {
            if (a.getId() != null) {
                dtoIds.add(a.getId());
            }
        });
        List sourceIds = this.presentDas.queryAllPresentIdsByGroupId(groupId);
        List<PresentEo> targetEos = targetList.stream().map(dto -> {
            PresentEo eo = new PresentEo();
            eo.setPresentsInfoId(groupId);
            BeanUtils.copyProperties((Object)dto, (Object)eo);
            return eo;
        }).collect(Collectors.toList());
        List<Long> needDelIds = sourceIds.stream().filter(a -> !dtoIds.contains(a)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(needDelIds)) {
            needDelIds.forEach(arg_0 -> ((PresentDas)this.presentDas).deleteById(arg_0));
        }
        if (CollectionUtils.isNotEmpty(targetEos)) {
            targetEos.forEach(upd -> {
                if (upd.getId() != null) {
                    this.presentDas.updateSelective((BaseEo)upd);
                } else {
                    this.presentDas.insert((BaseEo)upd);
                }
            });
        }
    }
}

