/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.schedule;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service.query.ICouponExtQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.TriggerTimeTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponEventService;
import java.util.List;
import javax.annotation.Resource;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="couponExpireSchedule")
@Scope(value="prototype")
public class CouponExpireSchedule
extends SingleTupleScheduleEvent {
    private static final Logger logger = LoggerFactory.getLogger(CouponExpireSchedule.class);
    @Resource
    private ICouponEventService couponEventService;
    @Resource
    private ICouponExtQueryApi couponExtQueryApi;

    public void before(TaskMsg taskMsg) {
    }

    public boolean execute(TaskMsg taskMsg) {
        logger.info("\u5b9a\u65f6\u67e5\u8be2\u8425\u9500\u7cfb\u7edf\u53d1\u653e\u4e14\u5df2\u8fc7\u671f\u7684\u4f18\u60e0\u5238, taskMsg={}", JSONObject.toJSON((Object)taskMsg));
        List<CouponExtRespDto> couponExtRespDtos = this.queryExpireCoupons(0, null);
        this.send(couponExtRespDtos);
        return true;
    }

    private List<CouponExtRespDto> queryExpireCoupons(Integer type, Integer subDay) {
        DateTime dateTime = TriggerTimeTypeEnum.BEFORE.isEqual(type) ? DateTime.now().plusDays(subDay.intValue()) : (TriggerTimeTypeEnum.AFTER.isEqual(type) ? DateTime.now().minusDays(subDay.intValue()) : DateTime.now());
        DateTime start = dateTime.withTime(0, 0, 0, 0);
        DateTime end = dateTime.withTime(23, 59, 59, 0);
        CouponReqDto queryDto = new CouponReqDto();
        queryDto.setInvalidTimeStart(start.toDate());
        queryDto.setInvalidTimeEnd(end.toDate());
        queryDto.setCouponStatus(CouponStatusEnum.CREATE.getStatus());
        logger.info("\u67e5\u8be2\u8fc7\u671f\u4f18\u60e0\u5238\u7684\u53c2\u6570=={}", (Object)JSONObject.toJSONString((Object)queryDto));
        List couponExtRespDtos = this.couponExtQueryApi.searchData(queryDto);
        return couponExtRespDtos;
    }

    private void send(List<CouponExtRespDto> values) {
        if (CollectionUtils.isEmpty(values)) {
            logger.info("\u672a\u67e5\u8be2\u5230\u6570\u636e\uff0c\u4efb\u52a1\u7ed3\u675f");
            return;
        }
        for (CouponExtRespDto value : values) {
            if (null == value.getUserId() || value.getUserId() < 1L) continue;
            CouponExtRespDto dto = new CouponExtRespDto();
            dto.setCouponName(value.getCouponName());
            dto.setCouponCode(value.getCouponCode());
            this.couponEventService.processExpireEvent(value.getUserId(), value.getCouponTemplateId(), dto, null);
        }
    }

    public void after(TaskMsg taskMsg) {
    }
}

