/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.fullreduction.condition;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.fullreduction.model.FullDecContent;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.fullreduction.model.FullDecRule;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.Param;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.utils.CalcUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.fullreduction.enums.DiscountRule;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.fullreduction.enums.PromotionMethod;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.fullreduction.enums.PromotionType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.fullreduction.enums.UnitEnum;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullReduceCondition
extends ConditionTemplate {
    private static Logger logger = LoggerFactory.getLogger(FullReduceCondition.class);
    private static final String PARAMS_NAME = "FullReduceCondition.rule";

    @Override
    public <T extends EngineParams> boolean execute(TemplateDefine define, ConditionRespDto conditionRespDto, T params, Map<String, ?> activityParams) {
        boolean meetThreshold;
        Param param = define.getParam(PARAMS_NAME);
        if (null == param) {
            throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u6ee1\u51cf\u6ee1\u6298\u6761\u4ef6\u672a\u914d\u7f6e"}));
        }
        FullDecRule fullDecRule = (FullDecRule)ConditionTemplate.converter(activityParams.get(PARAMS_NAME), param, define.getLoadClass());
        if (CollectionUtils.isEmpty((Collection)fullDecRule.getPromotionContents())) {
            throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u4fc3\u9500\u6761\u4ef6\u5185\u5bb9\u672a\u914d\u7f6e"}));
        }
        if (fullDecRule.getPromotionCondition().equals(DiscountRule.STAIR.getType())) {
            fullDecRule.getPromotionContents().sort(Comparator.comparing(FullDecContent::getThreshold, BigDecimal::compareTo));
        }
        if (!(meetThreshold = this.isMeetThreshold(params, fullDecRule))) {
            return false;
        }
        if (fullDecRule.getPromotionCondition().equals(DiscountRule.STAIR.getType())) {
            fullDecRule.getPromotionContents().sort(Comparator.comparing(FullDecContent::getThreshold, (a, b) -> b.compareTo((BigDecimal)a)));
        }
        logger.info("\u6ee1\u51cf\u89c4\u5219:{}", (Object)JSON.toJSONString((Object)fullDecRule));
        BigDecimal tempDiscountAmount = params.getTotalDiscountAmount();
        if (fullDecRule.getPromotionMethod().equals(PromotionMethod.ORDER.getType())) {
            logger.info("\u6ee1\u51cf\u6574\u5355:{}", (Object)JSON.toJSONString((Object)params.getItems()));
            this.calculate(params.getItems(), fullDecRule, params);
        } else {
            logger.info("\u6ee1\u51cf\u5355\u54c1:{}", (Object)JSON.toJSONString((Object)params.getItems()));
            for (ItemVo item : params.getItems()) {
                this.calculate(Lists.newArrayList((Object[])new ItemVo[]{item}), fullDecRule, params);
            }
        }
        BigDecimal totalDiscountAmount = params.getTotalDiscountAmount();
        BigDecimal activityDiscount = totalDiscountAmount.subtract(tempDiscountAmount);
        params.getActivityDiscountMap().put(String.valueOf(params.getActivityId()), activityDiscount);
        return meetThreshold;
    }

    public <T extends EngineParams> void calculate(List<ItemVo> items, FullDecRule fullDecRule, T params) {
        BigDecimal totalAmount = items.stream().map(itemVo -> itemVo.getPrice().multiply(BigDecimal.valueOf(itemVo.getNum()))).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal origTotalAmount = items.stream().map(itemVo -> itemVo.getOrigPrice().multiply(BigDecimal.valueOf(itemVo.getNum()))).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalItemNum = BigDecimal.valueOf(items.stream().mapToInt(ItemVo::getNum).sum());
        BigDecimal discountAmount = BigDecimal.ZERO;
        Integer logic = ((FullDecContent)fullDecRule.getPromotionContents().get(0)).getLogic();
        for (FullDecContent promotionContent : fullDecRule.getPromotionContents()) {
            BigDecimal discount;
            BigDecimal targetValue = promotionContent.getUnit().equals(UnitEnum.MONEY.getType()) ? totalAmount : totalItemNum;
            if (targetValue.compareTo(promotionContent.getThreshold()) <= -1) continue;
            boolean fullFold = false;
            if (fullDecRule.getPromotionType().equals(PromotionType.FULL_DISCOUNT.getType())) {
                discount = totalAmount.subtract(totalAmount.multiply(promotionContent.getDiscount()).divide(BigDecimal.TEN, params.getScale(), params.getRoundModel()));
                fullFold = true;
            } else {
                discount = promotionContent.getDiscount();
            }
            if (DiscountRule.STAIR.getType().equals(fullDecRule.getPromotionCondition())) {
                discountAmount = discountAmount.add(discount);
            } else if (DiscountRule.EACH_FULL.getType().equals(fullDecRule.getPromotionCondition())) {
                if (fullFold) {
                    discountAmount = discountAmount.add(discount);
                } else {
                    int length = targetValue.divide(promotionContent.getThreshold(), 2, 1).intValue();
                    discountAmount = discount.multiply(BigDecimal.valueOf(length));
                }
            }
            if (logic != 2) continue;
            break;
        }
        if (discountAmount.compareTo(BigDecimal.ZERO) == 1) {
            BigDecimal totalDiscounted = items.stream().map(ItemVo::getTotoalDiscountAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal residue = origTotalAmount.subtract(totalDiscounted);
            if (discountAmount.compareTo(residue) == 1) {
                discountAmount = residue;
            }
            params.setTotalDiscountAmount(params.getTotalDiscountAmount().add(discountAmount));
            CalcUtil.calculateDiscount(params.getActivityId(), items, discountAmount, null, null);
        }
    }

    private <T extends EngineParams> boolean isMeetThreshold(T params, FullDecRule fullDecRule) {
        FullDecContent content = (FullDecContent)fullDecRule.getPromotionContents().get(0);
        BigDecimal targetValue = BigDecimal.ZERO;
        Map<Object, Object> itemMap = Maps.newHashMap();
        if (PromotionMethod.ORDER.getType().equals(fullDecRule.getPromotionMethod())) {
            itemMap.put(null, params.getItems());
        } else {
            itemMap = params.getItems().stream().collect(Collectors.groupingBy(itemVo -> {
                String key = itemVo.getItemId() + itemVo.getSkuId() + itemVo.getShopId();
                return key;
            }));
        }
        boolean meet = false;
        ArrayList removeItems = Lists.newArrayList();
        for (Map.Entry<Object, Object> entry : itemMap.entrySet()) {
            List itemVos = (List)itemMap.get(entry.getKey());
            if (UnitEnum.MONEY.getType().equals(content.getUnit())) {
                BigDecimal totalAmount;
                targetValue = totalAmount = itemVos.stream().map(itemVo -> {
                    BigDecimal itemAmount = itemVo.getPrice().multiply(BigDecimal.valueOf(itemVo.getNum()));
                    return itemAmount;
                }).reduce(BigDecimal.ZERO, BigDecimal::add);
            } else {
                Integer totalItemNum = itemVos.stream().mapToInt(ItemVo::getNum).sum();
                targetValue = BigDecimal.valueOf(totalItemNum.intValue());
            }
            if (targetValue.compareTo(content.getThreshold()) > -1) {
                meet = true;
                continue;
            }
            removeItems.addAll(itemVos);
        }
        if (meet) {
            params.getItems().removeIf(itemVo -> removeItems.stream().anyMatch(removeItem -> {
                String removeKey = removeItem.getItemId() + removeItem.getSkuId() + removeItem.getShopId();
                String itemKey = itemVo.getItemId() + itemVo.getSkuId() + itemVo.getShopId();
                return removeKey.equals(itemKey);
            }));
        }
        return meet;
    }
}

