/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.timediscount.condition;

import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.PromotionMethodEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.DiscountAmount;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.Param;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.timediscount.model.TimePromotionPrice;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ConditionTemplate;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

public class PromotionPriceCondition
extends ConditionTemplate {
    private static final String PARAMS_NAME = "PromotionPriceCondition.prices";

    @Override
    public <T extends EngineParams> boolean execute(TemplateDefine define, ConditionRespDto conditionRespDto, T params, Map<String, ?> activityParams) {
        Param param = define.getParam(PARAMS_NAME);
        List promotionPrices = (List)ConditionTemplate.converter(activityParams.get(PARAMS_NAME), param, define.getLoadClass());
        BigDecimal tempDiscountAmount = params.getTotalDiscountAmount();
        params.getItems().removeIf(itemVo -> itemVo.getExchange() == 1);
        params.getItems().removeIf(itemVo -> itemVo.getIsCombinedPackage() == 1);
        for (ItemVo itemVo2 : params.getItems()) {
            for (TimePromotionPrice promotionPrice : promotionPrices) {
                BigDecimal skuDiscountAmount;
                BigDecimal discountPrice;
                if (!promotionPrice.getSkuId().toString().equals(itemVo2.getSkuId())) continue;
                if (PromotionMethodEnum.DISCOUNT.getCode().equals(promotionPrice.getPromotionMethod())) {
                    discountPrice = itemVo2.getPrice().multiply(promotionPrice.getDiscount()).divide(BigDecimal.TEN, params.getScale(), params.getRoundModel());
                    skuDiscountAmount = BigDecimal.valueOf(itemVo2.getNum()).multiply(itemVo2.getPrice().subtract(discountPrice));
                } else {
                    discountPrice = promotionPrice.getPrice();
                    skuDiscountAmount = BigDecimal.valueOf(itemVo2.getNum()).multiply(itemVo2.getPrice().subtract(promotionPrice.getPrice()));
                }
                itemVo2.setDiscountPrice(discountPrice);
                itemVo2.setPrice(discountPrice);
                if (BigDecimal.ZERO.compareTo(skuDiscountAmount) < 0) {
                    params.setTotalDiscountAmount(params.getTotalDiscountAmount().add(skuDiscountAmount));
                }
                DiscountAmount discountAmount = new DiscountAmount();
                discountAmount.setActivityId(conditionRespDto.getActivityId());
                discountAmount.setAmount(skuDiscountAmount);
                itemVo2.getActivityDiscountAmount().add(discountAmount);
            }
        }
        BigDecimal totalDiscountAmount = params.getTotalDiscountAmount();
        BigDecimal activityDiscount = totalDiscountAmount.subtract(tempDiscountAmount);
        params.getActivityDiscountMap().put(String.valueOf(params.getActivityId()), activityDiscount);
        return true;
    }
}

