/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemShelfQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopQueryDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponTemplateShopTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateShopDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.crowdordering.dto.request.ActivityItemDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.Param;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.tag.service.IItemActivityTagService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ItemConditionTemplate;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class CouponShopCondition
extends ItemConditionTemplate {
    private static Logger logger = LoggerFactory.getLogger(CouponShopCondition.class);
    public static final String COUPON_SHOP_CONDITION = "CouponShopCondition.shopIds";
    public static final String COUPON_SHOP_RANGE_TYPE = "CouponShopCondition.shopRangeType";
    @Autowired
    private IShopQueryApi shopQueryApi;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private IItemActivityTagService itemActivityTagService;
    @Resource
    private IActivityService activityService;

    @Override
    public <T extends EngineParams> boolean execute(TemplateDefine templateDefine, ConditionRespDto conditionRespDto, T context, Map<String, ?> configParams) {
        Param param = templateDefine.getParam(COUPON_SHOP_CONDITION);
        Param shopRangeTypeParam = templateDefine.getParam(COUPON_SHOP_RANGE_TYPE);
        if (null == param) {
            throw new ProBizException("\u5e97\u94fa\u6761\u4ef6\u672a\u914d\u7f6e");
        }
        List couponTemplateShopDtos = (List)ConditionTemplate.converter(configParams.get(COUPON_SHOP_CONDITION), param, templateDefine.getLoadClass());
        Integer shopRangeType = (Integer)ConditionTemplate.converter(configParams.get(COUPON_SHOP_RANGE_TYPE), shopRangeTypeParam, templateDefine.getLoadClass());
        List<String> shopIds = CouponShopCondition.parseEffectParams(couponTemplateShopDtos);
        if (shopRangeType == null && !CollectionUtils.isEmpty(shopIds)) {
            shopRangeType = CouponTemplateShopTypeEnum.INCLUDE_PART_SHOP.getType();
        }
        if (CollectionUtils.isEmpty(shopIds) || CouponTemplateShopTypeEnum.ALL_SHOP.getType().equals(shopRangeType)) {
            return true;
        }
        if (CouponTemplateShopTypeEnum.OFFLINE_SHOP.getType().equals(shopRangeType)) {
            this.filterUnMappingShop(context.getItems(), 1);
            this.validExistShopId(context.getItems());
        } else if (CouponTemplateShopTypeEnum.ONLINE_SHOP.getType().equals(shopRangeType)) {
            this.filterUnMappingShop(context.getItems(), 2);
            this.validExistShopId(context.getItems());
        } else if (CouponTemplateShopTypeEnum.EXCLUDE_PART_SHOP.getType().equals(shopRangeType)) {
            context.getItems().removeIf(itemVo -> itemVo.getShopId() != null && shopIds.contains(itemVo.getShopId()));
            this.validExistShopId(context.getItems());
        } else if (CouponTemplateShopTypeEnum.INCLUDE_PART_SHOP.getType().equals(shopRangeType)) {
            context.getItems().removeIf(itemVo -> itemVo.getShopId() != null && !shopIds.contains(itemVo.getShopId()));
            this.validExistShopId(context.getItems());
        }
        return true;
    }

    @Override
    public boolean apply(TemplateDefine define, ConditionRespDto conditionRespDto, ItemVo itemVo) {
        JSONObject configParams = JSON.parseObject((String)conditionRespDto.getConditionParams());
        ArrayList<ItemVo> items = new ArrayList<ItemVo>();
        items.add(itemVo);
        EngineParams engineParams = new EngineParams();
        engineParams.setItems(items);
        try {
            this.execute(define, conditionRespDto, (EngineParams)engineParams, (Map<String, ?>)configParams);
        }
        catch (ProBizException e) {
            logger.info("\u6761\u4ef6\u68c0\u67e5\u4e0d\u901a\u8fc7", (Throwable)e);
            return false;
        }
        return true;
    }

    private void filterUnMappingShop(List<ItemVo> itemVos, Integer managerType) {
        ShopQueryDto queryDto = new ShopQueryDto();
        queryDto.setTenantId(ServiceContext.getContext().getRequestTenantId());
        itemVos.removeIf(itemVo -> {
            ShopDto shopDto;
            queryDto.setCode(itemVo.getShopId());
            PageInfo pageInfo = (PageInfo)this.shopQueryApi.queryByConditions(queryDto, 1, 1).getData();
            return pageInfo == null || CollectionUtils.isEmpty((Collection)pageInfo.getList()) || (shopDto = (ShopDto)pageInfo.getList().get(0)).getManageType() == null || !shopDto.getManageType().equals(managerType);
        });
    }

    private void validExistShopId(List<ItemVo> itemVos) {
        if (CollectionUtils.isEmpty(itemVos)) {
            throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u5546\u54c1\u5e97\u94fa\u4e0d\u7b26\u5408\uff0c\u65e0\u6cd5\u4f7f\u7528\u4f18\u60e0\u5238"}));
        }
    }

    @Override
    public Set<ActivityItemDto> getItems(TemplateDefine define, ConditionRespDto conditionRespDto, Map<String, ?> configParams) {
        Param param = define.getParam(COUPON_SHOP_CONDITION);
        if (null == param) {
            throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u5e97\u94fa\u6761\u4ef6\u672a\u914d\u7f6e"}));
        }
        List couponTemplateShopDtos = (List)ConditionTemplate.converter(configParams.get(COUPON_SHOP_CONDITION), param, define.getLoadClass());
        List<String> shopIds = CouponShopCondition.parseEffectParams(couponTemplateShopDtos);
        ActivityRespDto activityRespDto = this.activityService.queryById(conditionRespDto.getActivityId());
        if (null == activityRespDto) {
            return Collections.EMPTY_SET;
        }
        ItemShelfQueryReqDto queryReqDto = new ItemShelfQueryReqDto();
        queryReqDto.setInstanceId(activityRespDto.getInstanceId());
        queryReqDto.setTenantId(activityRespDto.getTenantId());
        queryReqDto.setSellerId(activityRespDto.getSellerId());
        queryReqDto.setShopId(activityRespDto.getShopId());
        List shopIdList = shopIds.stream().map(id -> Long.valueOf(id)).collect(Collectors.toList());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(shopIdList)) {
            queryReqDto.setShopIds(shopIdList);
        }
        return this.itemActivityTagService.queryItemsForB2b(queryReqDto);
    }

    public static List<CouponTemplateShopDto> parseParams(String conditionParams) {
        if (StringUtils.isBlank((CharSequence)conditionParams)) {
            return Collections.emptyList();
        }
        logger.info("json=={}", (Object)conditionParams);
        JSONArray jsonArray = JSON.parseObject((String)conditionParams).getJSONArray(COUPON_SHOP_CONDITION);
        if (jsonArray == null) {
            return Collections.emptyList();
        }
        return jsonArray.toJavaList(CouponTemplateShopDto.class);
    }

    public static Integer parseShopRangeType(String conditionParams) {
        if (StringUtils.isBlank((CharSequence)conditionParams)) {
            return null;
        }
        return JSON.parseObject((String)conditionParams).getInteger(COUPON_SHOP_RANGE_TYPE);
    }

    public static List<String> parseEffectParams(List<CouponTemplateShopDto> conditionParams) {
        if (CollectionUtils.isEmpty(conditionParams)) {
            return Collections.emptyList();
        }
        return conditionParams.stream().filter(param -> param == null || param.isEffective() == true).map(CouponTemplateShopDto::getShopCode).collect(Collectors.toList());
    }
}

