/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.center.member.api.basis.query.IMemberQueryApi;
import com.dtyunxi.yundt.cube.center.member.api.common.dto.response.MemberRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionExtCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.Param;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.utils.MapUtils;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore.enums.PointExchangeType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore.vo.PointExchangeVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ConditionTemplate;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;

public class PointExchangeCondition
extends ConditionTemplate {
    private static final String TYPE = "PointExchangeCondition.type";
    public static final String CONDITION = "PointExchangeCondition.condition";
    public static final String LIMIT = "PointExchangeCondition.dayLimit";
    @Resource
    private IMemberQueryApi memberQueryApi;

    @Override
    public <T extends EngineParams> boolean execute(TemplateDefine templateDefine, ConditionRespDto conditionRespDto, T context, Map<String, ?> configParams) {
        Integer num;
        Integer limit;
        Param typeParam = templateDefine.getParam(TYPE);
        if (null == typeParam) {
            throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u5151\u6362\u7c7b\u578b\u672a\u914d\u7f6e"}));
        }
        Integer type = (Integer)ConditionTemplate.converter(configParams.get(TYPE), typeParam, templateDefine.getLoadClass());
        Param conditionParam = templateDefine.getParam(CONDITION);
        if (null == conditionParam) {
            throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u6761\u4ef6\u672a\u914d\u7f6e"}));
        }
        List pointExchangeVos = (List)ConditionTemplate.converter(configParams.get(CONDITION), conditionParam, templateDefine.getLoadClass());
        if (CollectionUtils.isEmpty((Collection)pointExchangeVos)) {
            throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u65e0\u53ef\u5151\u6362\u7684\u5546\u54c1"}));
        }
        Param limitParam = templateDefine.getParam(LIMIT);
        if (null != limitParam && null != (limit = (Integer)ConditionTemplate.converter(configParams.get(LIMIT), limitParam, templateDefine.getLoadClass())) && limit > 0 && (num = (Integer)((ICacheService)SpringBeanUtil.getBean(ICacheService.class)).getCache(LIMIT + context.getActivityId() + context.getUserId(), Integer.class)) != null && limit <= num) {
            throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u5df2\u8d85\u8fc7\u6700\u5927\u5355\u65e5\u5151\u6362\u6b21\u6570"}));
        }
        PointExchangeType exchangeType = PointExchangeType.getByType(type);
        Map<String, PointExchangeVo> exchangeVoMap = this.convertExchangeMap(pointExchangeVos);
        Map extendsAttribute = context.getExtendsAttribute();
        int sumPoints = 0;
        for (ItemVo item : context.getItems()) {
            HashMap resultMap = Maps.newHashMap();
            PointExchangeVo currConfigVo = exchangeVoMap.get(item.getItemId());
            if (currConfigVo == null) {
                throw new ProBizException(ProExceptionCode.PARAMS_ERR.format(new String[]{"\u5151\u6362\u7269\u54c1\u4e0d\u5b58\u5728\u53ef\u5151\u6362\u5217\u8868\u4e2d"}));
            }
            BigDecimal num2 = new BigDecimal(item.getNum());
            if (null == currConfigVo.getSalePrice()) {
                item.setPrice(BigDecimal.ZERO);
            } else {
                item.setPrice(currConfigVo.getSalePrice().multiply(num2));
            }
            if (null == currConfigVo.getPrice()) {
                item.setDiscountPrice(BigDecimal.ZERO);
            } else {
                item.setDiscountPrice(currConfigVo.getPrice().multiply(num2));
            }
            resultMap.put(item.getItemId(), item.getNum());
            Map sourceCoupons = (Map)MapUtils.getObject((Map)extendsAttribute, (Object)"returnCoupon", new HashMap(1));
            BigDecimal points = currConfigVo.getPoints().multiply(num2);
            sumPoints += points.intValue();
            item.addExtendsAttribute("additionalPoints", (Object)points);
            Map<String, Integer> result = Stream.concat(resultMap.entrySet().stream(), sourceCoupons.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Integer::sum));
            if (exchangeType.equals((Object)PointExchangeType.ITEM)) {
                extendsAttribute.put("returnGift", result);
                continue;
            }
            extendsAttribute.put("returnCoupon", result);
            item.addExtendsAttribute("returnCoupon", (Object)resultMap);
            item.setItemId("0");
        }
        try {
            int availablePoints = ((MemberRespDto)this.memberQueryApi.queryMemberAndItemsById(Long.valueOf(context.getUserId()), new String[]{"account"}).getData()).getPointsAccountDto().getAvailablePoints();
            if (availablePoints < sumPoints) {
                throw new ProBizException((ProExceptionCode)ProExceptionExtCode.EXCHANGE_POINTS_USER_POINT_NOT_ENOUGH);
            }
        }
        catch (Exception e) {
            throw new ProBizException((ProExceptionCode)ProExceptionExtCode.EXCHANGE_POINTS_USER_POINT_NOT_ENOUGH);
        }
        context.addExtAttribute("exchange_points_sum_point", (Object)sumPoints);
        return true;
    }

    private Map<String, PointExchangeVo> convertExchangeMap(List<PointExchangeVo> pointExchangeVos) {
        HashMap result = Maps.newHashMap();
        pointExchangeVos.forEach(vo -> result.put(vo.getObjCode(), vo));
        return result;
    }
}

