/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.apiimpl.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityItemListReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityTagQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityRelationRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityRespExtDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ItemActivityPriceMkRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.PreviewActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.PromotionCouponRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.IActivityRelationService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityPreviewService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.BeanCopyUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ActivityAuditEo;
import com.github.pagehelper.PageInfo;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import javax.validation.constraints.Min;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestParam;

@Service(value="activityQueryApiImpl")
public class ActivityQueryApiImpl
implements IActivityQueryApi {
    @Autowired
    private IActivityService activityService;
    @Resource
    private IActivityRelationService activityRelationService;
    @Autowired
    private IActivityPreviewService activityPreviewService;

    public RestResponse<ActivityRespDto> queryActivityDetail(@Min(value=1L, message="\u8bf7\u4f20\u5165\u5408\u6cd5\u6d3b\u52a8ID") @Min(value=1L, message="\u8bf7\u4f20\u5165\u5408\u6cd5\u6d3b\u52a8ID") long acId) {
        return new RestResponse((Object)this.activityService.getById(acId));
    }

    public RestResponse<ActivityRespDto> queryActivityFatDetail(long acId) {
        return new RestResponse((Object)this.activityService.getActivity(acId));
    }

    public RestResponse<List<Long>> queryActuatingByCp(String checkPoint) {
        return new RestResponse(this.activityService.queryActuatingByCp(checkPoint));
    }

    public RestResponse<List<ActivityRespDto>> queryActivityList(ActivityDto queryDto) {
        return new RestResponse(this.activityService.queryActivityList(queryDto, 0, 0));
    }

    public RestResponse<PageInfo<ActivityRespDto>> queryActivityPage(@SpringQueryMap ActivityDto queryDto, @RequestParam(value="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize) {
        return new RestResponse(this.activityService.queryActivityList(queryDto, pageNum, pageSize));
    }

    public RestResponse<List<ItemActivityPriceMkRespDto>> queryItemActivityPrice(ActivityItemListReqDto activityItemListReqDto) {
        return new RestResponse(this.activityService.queryItemActivityPrice(activityItemListReqDto));
    }

    public RestResponse<List<ActivityRespExtDto>> inverseQuery(long itemId, long userId, boolean validStatus) {
        return new RestResponse(this.activityService.inverseQuery(itemId, userId, validStatus));
    }

    public RestResponse<List<ActivityRespDto>> queryAuditData(long activityId) {
        List<ActivityAuditEo> activityAuditEos = this.activityService.queryAuditData(activityId);
        return new RestResponse(BeanCopyUtil.copyCollections(activityAuditEos, ActivityRespDto.class, new String[0]));
    }

    public RestResponse<List<ActivityRelationRespDto>> queryActivityRelations(Long activityId) {
        return new RestResponse(this.activityRelationService.queryByActivityId(activityId));
    }

    public RestResponse<PreviewActivityRespDto> previewActivity(EngineParams engineParams) {
        return new RestResponse((Object)this.activityPreviewService.previewActivity(engineParams));
    }

    public RestResponse<PromotionCouponRespDto> queryActivityByItem(ItemActivityTagQueryReqDto itemActivityTagQueryReqDto) {
        return new RestResponse((Object)this.activityPreviewService.queryActivityByItem(itemActivityTagQueryReqDto));
    }

    public RestResponse<List<Long>> queryActivityTemIdsByIds(Set<Long> activityIds) {
        return new RestResponse(this.activityService.queryActivityTemIdsByIds(activityIds));
    }
}

