/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.apiimpl;

import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.IActivityExtApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.DepositInfoReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.PromotionInfoReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.PromotionPointInfoReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.response.DepositInfoRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.response.PromotionGenInfoRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.response.PromotionPointInfoRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.IActivityExtService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.tag.service.IItemActivityTagService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.seckill.ISeckillService;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="activityExtApi")
public class ActivityExtApiImpl
implements IActivityExtApi {
    private static final Logger logger = LoggerFactory.getLogger(ActivityExtApiImpl.class);
    @Resource
    private IActivityExtService activityExtService;
    @Autowired
    private ICommonsMqService mqService;
    @Autowired
    private ISeckillService seckillService;
    @Autowired
    private IItemActivityTagService itemActivityTagService;

    public RestResponse<Void> enableById(Long activityId) {
        this.activityExtService.enableById(activityId);
        MessageResponse messageResponse = this.mqService.sendSingleMessage("ACTIVITY_SYNC_ENABLE_TAG", (Object)activityId);
        if (messageResponse != null) {
            logger.info("\u53d1\u9001\u542f\u7528msgId:{}", messageResponse.getData());
        }
        return RestResponse.VOID;
    }

    public RestResponse<Void> enableBatch(List<Long> ids) {
        this.activityExtService.enableBatch(ids);
        ids.forEach(id -> {
            MessageResponse messageResponse = this.mqService.sendSingleMessage("ACTIVITY_SYNC_ENABLE_TAG", id);
            if (messageResponse != null) {
                logger.info("\u53d1\u9001\u542f\u7528msgId:{}", messageResponse.getData());
            }
        });
        return RestResponse.VOID;
    }

    public RestResponse<Void> disableById(Long activityId) {
        this.activityExtService.disableById(activityId);
        this.mqService.sendSingleMessage("ACTIVITY_SYNC_DISABLE_TAG", (Object)activityId);
        return RestResponse.VOID;
    }

    public RestResponse<Void> disableBatch(List<Long> ids) {
        this.activityExtService.disableBatch(ids);
        ids.forEach(id -> this.mqService.sendSingleMessage("ACTIVITY_SYNC_DISABLE_TAG", id));
        return RestResponse.VOID;
    }

    public RestResponse<Void> deleteById(Long id) {
        this.activityExtService.deleteById(id);
        return RestResponse.VOID;
    }

    public RestResponse<Void> deleteBatch(List<Long> ids) {
        this.activityExtService.deleteBatch(ids);
        return RestResponse.VOID;
    }

    public RestResponse<DepositInfoRespDto> deposit(DepositInfoReqDto dto) {
        DepositInfoRespDto respDto = this.activityExtService.deposit(dto, false);
        return new RestResponse((Object)respDto);
    }

    public RestResponse<PromotionGenInfoRespDto> promotion(PromotionInfoReqDto dto, Long activityTemplateId) {
        PromotionGenInfoRespDto respDto = this.activityExtService.promotion(dto, activityTemplateId);
        return new RestResponse((Object)respDto);
    }

    public RestResponse<PromotionPointInfoRespDto> points(PromotionPointInfoReqDto dto) {
        PromotionPointInfoRespDto respDto = this.activityExtService.points(dto);
        return new RestResponse((Object)respDto);
    }

    public RestResponse<Void> saveSingleItemByActivity(Long activityId) {
        this.itemActivityTagService.saveSingleItemByActivity(activityId);
        return RestResponse.VOID;
    }
}

