/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.apiimpl.query;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopQueryDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponHierarchyEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponTemplateShopTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.OrderMatchCouponReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponMoneyOffDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateBrandDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateItemDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateShopDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service.query.ICouponOrderQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponValidityTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.query.IConditionExtQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.config.CouponConfig;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponTemplateExtQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.query.ICouponExtQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore.CouponMoneyOffCondition;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="couponOrderQueryApi")
public class CouponOrderQueryApiImpl
implements ICouponOrderQueryApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICouponExtQueryService couponExtQueryService;
    @Autowired
    private ICouponTemplateExtQueryService couponTemplateExtQueryService;
    @Autowired
    private IConditionExtQueryService conditionExtQueryService;
    @Autowired
    private CouponConfig couponConfig;
    @Autowired
    private IShopQueryApi shopQueryApi;

    public RestResponse<List<CouponExtRespDto>> orderMatch(OrderMatchCouponReqDto orderMatchCouponReqDto) {
        List orderItemList;
        List<Object> list = this.couponExtQueryService.listByUserId(orderMatchCouponReqDto.getMemberId(), CouponStatusEnum.CREATE.getStatus());
        List<Long> couponTemplateIds = list.stream().map(CouponExtRespDto::getCouponTemplateId).distinct().collect(Collectors.toList());
        Map<Long, CouponTemplateExtRespDto> couponTemplateExtRespDtoMap = this.couponTemplateExtQueryService.listByIds2Map(couponTemplateIds);
        Date orderDate = orderMatchCouponReqDto.getOrderDate();
        List list2 = orderItemList = org.apache.commons.collections.CollectionUtils.isEmpty((Collection)orderMatchCouponReqDto.getItemVos()) ? Collections.emptyList() : orderMatchCouponReqDto.getItemVos();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)orderItemList)) {
            throw new ProBizException(ProExceptionCode.ORDER_ITEM_NOT_ALLOW_EMPTY_ERR);
        }
        if (orderMatchCouponReqDto.getHierarchy() != null && org.apache.commons.collections.CollectionUtils.isNotEmpty(list)) {
            this.logger.info("\u8fc7\u6ee4\u4f7f\u7528\u5c42\u7ea7, hierarchy={}", (Object)orderMatchCouponReqDto.getHierarchy());
            list = list.stream().filter(couponExtRespDto -> couponExtRespDto.getHierarchy().equals(orderMatchCouponReqDto.getHierarchy())).collect(Collectors.toList());
        }
        list = this.filterCouponTime(list, orderDate, couponTemplateExtRespDtoMap);
        this.preSetCouponAvailableItem(list, orderItemList);
        list = this.filterCouponShop(list, orderMatchCouponReqDto, couponTemplateExtRespDtoMap);
        list = this.filterCouponCatalog(list, orderMatchCouponReqDto, couponTemplateExtRespDtoMap);
        list = this.filterCouponBrand(list, orderMatchCouponReqDto, couponTemplateExtRespDtoMap);
        list = this.filterCouponAmount(list, orderMatchCouponReqDto, couponTemplateExtRespDtoMap);
        return new RestResponse(list);
    }

    private void preSetCouponAvailableItem(List<CouponExtRespDto> list, List<ItemVo> itemVos) {
        if (list == null || itemVos == null) {
            return;
        }
        list.forEach(n -> {
            ArrayList tempItemVos = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)tempItemVos, (Collection)itemVos, ItemVo.class);
            n.setAvailableItems((List)tempItemVos);
        });
    }

    private boolean validateItem(CouponExtRespDto couponExtRespDto, OrderMatchCouponReqDto orderMatchCouponReqDto, CouponTemplateExtRespDto couponTemplateExtRespDto) {
        List couponItemCodeList = couponTemplateExtRespDto.getCouponItemList().stream().filter(CouponTemplateItemDto::isEffective).map(CouponTemplateItemDto::getItemCode).collect(Collectors.toList());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(couponItemCodeList)) {
            this.logger.info("\u6821\u9a8c\u4f18\u60e0\u5238, \u4f18\u60e0\u5238\u6a21\u677f\u6ca1\u6709\u914d\u7f6e\u5546\u54c1\uff0c\u65e0\u9700\u8fc7\u6ee4, couponCode={}", (Object)couponExtRespDto.getCouponCode());
            return true;
        }
        List orderItemCodes = orderMatchCouponReqDto.getItemVos().stream().map(ItemVo::getItemId).collect(Collectors.toList());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(orderItemCodes)) {
            this.logger.info("\u6821\u9a8c\u4f18\u60e0\u5238, \u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728, couponCode={}, orderItemCodes={}", (Object)couponExtRespDto.getCouponCode(), orderItemCodes);
            return false;
        }
        boolean isIncludeItem = false;
        for (String itemCode : orderItemCodes) {
            if (isIncludeItem) break;
            isIncludeItem = couponItemCodeList.contains(itemCode);
        }
        if (!isIncludeItem) {
            this.logger.info("\u6821\u9a8c\u4f18\u60e0\u5238, \u4e0d\u5728\u5546\u54c1\u8303\u56f4\u5185, couponCode={}, orderItemCodes={}", (Object)couponExtRespDto.getCouponCode(), orderItemCodes);
            return false;
        }
        if (orderMatchCouponReqDto.getOrderAmount().compareTo(couponExtRespDto.getAmount()) >= 0) {
            couponExtRespDto.getAvailableItems().removeIf(n -> !couponItemCodeList.contains(n.getItemId()));
            return true;
        }
        this.logger.info("\u6821\u9a8c\u4f18\u60e0\u5238\u8ba2\u5355\u91d1\u989d\u53ef\u7528\u4e0d\u6ee1\u8db3\u6761\u4ef6\uff0c\u4f18\u60e0\u5238\u7f16\u53f7\uff1a{}\uff0c \u8ba2\u5355\u91d1\u989d\uff1a{}", (Object)couponExtRespDto.getCouponCode(), (Object)orderMatchCouponReqDto.getOrderAmount());
        return false;
    }

    public boolean checkAmount(CouponExtRespDto couponExtRespDto, CouponTemplateExtRespDto couponTemplateExtRespDto) {
        BigDecimal orderAmount = BigDecimal.ZERO;
        for (ItemVo itemVo : couponExtRespDto.getAvailableItems()) {
            orderAmount = orderAmount.add(itemVo.getPrice().multiply(new BigDecimal(itemVo.getNum())));
        }
        CouponMoneyOffDto couponMoneyOffDto = couponTemplateExtRespDto.getCouponMoneyOffDto();
        boolean judgeMoney = CouponMoneyOffCondition.judgeMoneyOffCondition(orderAmount, couponTemplateExtRespDto.getCouponCategory(), couponMoneyOffDto);
        if (!judgeMoney) {
            return judgeMoney;
        }
        return orderAmount.compareTo(couponExtRespDto.getAmount()) >= 0;
    }

    private List<CouponExtRespDto> filterCouponTime(List<CouponExtRespDto> list, Date orderDate, Map<Long, CouponTemplateExtRespDto> couponTemplateExtRespDtoMap) {
        if (orderDate != null && org.apache.commons.collections.CollectionUtils.isNotEmpty(list)) {
            this.logger.info("\u5224\u65ad\u662f\u5426\u5728\u4f7f\u7528\u65f6\u95f4\u8303\u56f4\u5185, orderDate={}", (Object)JSON.toJSONString((Object)orderDate));
            return list.stream().filter(couponExtRespDto -> {
                CouponTemplateExtRespDto couponTemplateExtRespDto = (CouponTemplateExtRespDto)couponTemplateExtRespDtoMap.get(couponExtRespDto.getCouponTemplateId());
                if (null == couponTemplateExtRespDto) {
                    return false;
                }
                couponExtRespDto.setCouponTemplate(couponTemplateExtRespDto);
                couponExtRespDto.setCouponRange(couponTemplateExtRespDto.getCouponRange());
                if (CouponValidityTypeEnum.DYNAMIC_DATE.getType().equals(couponExtRespDto.getValidityType())) {
                    return couponExtRespDto.getEffectiveTime().before(orderDate) && couponExtRespDto.getInvalidTime().after(orderDate);
                }
                return couponTemplateExtRespDto.getEffectiveTime().before(orderDate) && couponTemplateExtRespDto.getInvalidTime().after(orderDate);
            }).collect(Collectors.toList());
        }
        return list;
    }

    private List<CouponExtRespDto> filterCouponShop(List<CouponExtRespDto> list, OrderMatchCouponReqDto orderMatchCouponReqDto, Map<Long, CouponTemplateExtRespDto> couponTemplateExtRespDtoMap) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(list)) {
            List storeIds = orderMatchCouponReqDto.getItemVos().stream().map(ItemVo::getShopId).collect(Collectors.toList());
            if (org.apache.commons.collections.CollectionUtils.isEmpty(storeIds)) {
                return list;
            }
            list = list.stream().filter(couponExtRespDto -> {
                CouponTemplateExtRespDto couponTemplate = (CouponTemplateExtRespDto)couponTemplateExtRespDtoMap.get(couponExtRespDto.getCouponTemplateId());
                return this.filterShopPredicate(couponTemplate, (CouponExtRespDto)couponExtRespDto, storeIds);
            }).collect(Collectors.toList());
        }
        return list;
    }

    private boolean filterShopPredicate(CouponTemplateExtRespDto couponTemplate, CouponExtRespDto couponExtRespDto, List<String> storeIds) {
        boolean isAllShopRange;
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)couponExtRespDto.getAvailableItems()) || null == couponTemplate) {
            this.logger.info("\u5224\u65ad\u5e97\u94fa\u6761\u4ef6\uff0c\u4f18\u60e0\u5238{}\u6ca1\u6709\u53ef\u7528\u5546\u54c1\uff0c\u6216\u4f18\u60e0\u5238\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u4e0d\u6ee1\u8db3\u4f7f\u7528\u6761\u4ef6", (Object)couponExtRespDto.getCouponCode());
            return false;
        }
        List couponTemplateShopDtos = couponTemplate.getCouponShopList();
        boolean bl = isAllShopRange = couponTemplate.getShopRangeType() == null && org.apache.commons.collections.CollectionUtils.isEmpty((Collection)couponTemplateShopDtos) || CouponTemplateShopTypeEnum.ALL_SHOP.getType().equals(couponTemplate.getShopRangeType());
        if (isAllShopRange) {
            return true;
        }
        List couponTemplateShopCodes = couponTemplateShopDtos.stream().filter(n -> n.isEffective() == null || n.isEffective() != false).map(CouponTemplateShopDto::getShopCode).collect(Collectors.toList());
        if (couponTemplate.getShopRangeType() == null || CouponTemplateShopTypeEnum.INCLUDE_PART_SHOP.getType().equals(couponTemplate.getShopRangeType())) {
            boolean containShopId = org.apache.commons.collections.CollectionUtils.containsAny(couponTemplateShopCodes, storeIds);
            if (!containShopId) {
                this.logger.info("\u4f18\u60e0\u5238{}\u4e0d\u6ee1\u8db3\u5e97\u94fa\u914d\u7f6e\uff0c\u4e0d\u53ef\u7528\uff0c \u53ef\u7528\u5e97\u94fa\u4e3a: {}", (Object)couponExtRespDto.getCouponCode(), couponTemplateShopCodes);
                return false;
            }
            couponExtRespDto.getAvailableItems().removeIf(n -> !couponTemplateShopCodes.contains(n.getShopId()));
            return true;
        }
        if (CouponTemplateShopTypeEnum.EXCLUDE_PART_SHOP.getType().equals(couponTemplate.getShopRangeType())) {
            HashSet excludeShop = Sets.newHashSet(couponTemplateShopCodes);
            HashSet orderShop = Sets.newHashSet(storeIds);
            Sets.SetView views = Sets.difference((Set)orderShop, (Set)excludeShop);
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)views)) {
                this.logger.info("\u4f18\u60e0\u5238{}\u4e0d\u6ee1\u8db3\u5e97\u94fa\u914d\u7f6e\uff0c\u4e0d\u53ef\u7528\uff0c \u53ef\u7528\u5e97\u94fa\u4e3a: {}", (Object)couponExtRespDto.getCouponCode(), couponTemplateShopCodes);
                return false;
            }
            couponExtRespDto.getAvailableItems().removeIf(n -> couponTemplateShopCodes.contains(n.getShopId()));
            return true;
        }
        if (CouponTemplateShopTypeEnum.ONLINE_SHOP.getType().equals(couponTemplate.getShopRangeType())) {
            List<String> onlineShops = this.getShopRangeType(couponExtRespDto, storeIds, 2);
            return org.apache.commons.collections.CollectionUtils.isNotEmpty(onlineShops);
        }
        if (CouponTemplateShopTypeEnum.OFFLINE_SHOP.getType().equals(couponTemplate.getShopRangeType())) {
            List<String> onlineShops = this.getShopRangeType(couponExtRespDto, storeIds, 1);
            return org.apache.commons.collections.CollectionUtils.isNotEmpty(onlineShops);
        }
        return false;
    }

    private List<String> getShopRangeType(CouponExtRespDto couponExtRespDto, List<String> shopCode, Integer managerType) {
        ArrayList filterShopCode = Lists.newArrayList();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(shopCode)) {
            return filterShopCode;
        }
        ShopQueryDto queryDto = new ShopQueryDto();
        queryDto.setTenantId(ServiceContext.getContext().getRequestTenantId());
        for (String s : shopCode) {
            ShopDto shopDto;
            queryDto.setCode(s);
            PageInfo pageInfo = (PageInfo)this.shopQueryApi.queryByConditions(queryDto, 1, 1).getData();
            if (pageInfo == null || CollectionUtils.isEmpty((Collection)pageInfo.getList()) || (shopDto = (ShopDto)pageInfo.getList().get(0)).getManageType() == null || !shopDto.getManageType().equals(managerType)) continue;
            filterShopCode.add(s);
        }
        this.logger.info("\u5e97\u94fa\u6570\u91cf:{}", (Object)filterShopCode.size());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)filterShopCode)) {
            couponExtRespDto.getAvailableItems().removeIf(n -> !filterShopCode.contains(n));
        }
        return filterShopCode;
    }

    private List<CouponExtRespDto> filterCouponCatalog(List<CouponExtRespDto> list, OrderMatchCouponReqDto orderMatchCouponReqDto, Map<Long, CouponTemplateExtRespDto> couponTemplateExtRespDtoMap) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(list)) {
            ArrayList orderCatalogIds = Lists.newArrayList();
            orderMatchCouponReqDto.getItemVos().forEach(catalog -> orderCatalogIds.addAll(catalog.getItemCategory()));
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)orderCatalogIds)) {
                return list;
            }
            list = list.stream().filter(coupon -> {
                CouponTemplateExtRespDto couponTemplate = (CouponTemplateExtRespDto)couponTemplateExtRespDtoMap.get(coupon.getCouponTemplateId());
                if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)coupon.getAvailableItems()) || couponTemplate == null) {
                    this.logger.info("\u5224\u65ad\u7c7b\u76ee\u6761\u4ef6\uff0c\u4f18\u60e0\u5238{}\u6ca1\u6709\u53ef\u7528\u5546\u54c1\uff0c\u6216\u4f18\u60e0\u5238\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u4e0d\u6ee1\u8db3\u4f7f\u7528\u6761\u4ef6", (Object)coupon.getCouponCode());
                    return false;
                }
                List templateCatalogIds = couponTemplate.getCouponTemplateCatalogDtoList();
                if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)templateCatalogIds)) {
                    return true;
                }
                boolean categoryValidResult = org.apache.commons.collections.CollectionUtils.containsAny((Collection)templateCatalogIds, (Collection)orderCatalogIds);
                if (!categoryValidResult) {
                    this.logger.info("\u4f18\u60e0\u5238{}\u4e0d\u6ee1\u8db3\u7c7b\u76ee\u914d\u7f6e\uff0c\u4e0d\u53ef\u7528\uff0c \u53ef\u7528\u7c7b\u76ee\u4e3a: {}", (Object)coupon.getCouponCode(), (Object)templateCatalogIds);
                    return false;
                }
                coupon.getAvailableItems().removeIf(n -> !org.apache.commons.collections.CollectionUtils.containsAny((Collection)templateCatalogIds, (Collection)n.getItemCategory()));
                return true;
            }).collect(Collectors.toList());
        }
        return list;
    }

    private List<CouponExtRespDto> filterCouponBrand(List<CouponExtRespDto> list, OrderMatchCouponReqDto orderMatchCouponReqDto, Map<Long, CouponTemplateExtRespDto> couponTemplateExtRespDtoMap) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(list)) {
            ArrayList orderBrandIds = Lists.newArrayList();
            for (ItemVo itemVo : orderMatchCouponReqDto.getItemVos()) {
                orderBrandIds.addAll(itemVo.getItemBrands());
            }
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)orderBrandIds)) {
                return list;
            }
            list = list.stream().filter(coupon -> {
                CouponTemplateExtRespDto couponTemplate = (CouponTemplateExtRespDto)couponTemplateExtRespDtoMap.get(coupon.getCouponTemplateId());
                if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)coupon.getAvailableItems()) || couponTemplate == null) {
                    this.logger.info("\u5224\u65ad\u54c1\u724c\u6761\u4ef6\uff0c\u4f18\u60e0\u5238{}\u6ca1\u6709\u53ef\u7528\u5546\u54c1\uff0c\u6216\u4f18\u60e0\u5238\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u4e0d\u6ee1\u8db3\u4f7f\u7528\u6761\u4ef6", (Object)coupon.getCouponCode());
                    return false;
                }
                List couponTemplateBrandDtos = couponTemplate.getCouponTemplateBrandDtoList();
                if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)couponTemplateBrandDtos)) {
                    return true;
                }
                List templateBrandIds = couponTemplateBrandDtos.stream().map(CouponTemplateBrandDto::getBrandId).collect(Collectors.toList());
                boolean brandValidResult = org.apache.commons.collections.CollectionUtils.containsAny(templateBrandIds, (Collection)orderBrandIds);
                if (!brandValidResult) {
                    this.logger.info("\u4f18\u60e0\u5238{}\u4e0d\u6ee1\u8db3\u54c1\u724c\u914d\u7f6e\uff0c\u4e0d\u53ef\u7528\uff0c \u53ef\u7528\u54c1\u724c\u4e3a: {}", (Object)coupon.getCouponCode(), templateBrandIds);
                    return false;
                }
                coupon.getAvailableItems().removeIf(n -> !org.apache.commons.collections.CollectionUtils.containsAny((Collection)templateBrandIds, (Collection)n.getItemBrands()));
                return true;
            }).collect(Collectors.toList());
        }
        return list;
    }

    private List<CouponExtRespDto> filterCouponAmount(List<CouponExtRespDto> list, OrderMatchCouponReqDto orderMatchCouponReqDto, Map<Long, CouponTemplateExtRespDto> couponTemplateExtRespDtoMap) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(list)) {
            BigDecimal orderAmount = orderMatchCouponReqDto.getOrderAmount();
            list = list.stream().filter(couponExtRespDto -> {
                CouponTemplateExtRespDto couponTemplateExtRespDto = (CouponTemplateExtRespDto)couponTemplateExtRespDtoMap.get(couponExtRespDto.getCouponTemplateId());
                if (couponTemplateExtRespDto.getHierarchy().equals(CouponHierarchyEnum.GENERAL.getHierarchy())) {
                    boolean itemResult = this.validateItem((CouponExtRespDto)couponExtRespDto, orderMatchCouponReqDto, couponTemplateExtRespDto);
                    if (!itemResult) {
                        return itemResult;
                    }
                    return this.checkAmount((CouponExtRespDto)couponExtRespDto, couponTemplateExtRespDto);
                }
                if (couponTemplateExtRespDto.getHierarchy().equals(CouponHierarchyEnum.ITEM.getHierarchy())) {
                    return this.validateItem((CouponExtRespDto)couponExtRespDto, orderMatchCouponReqDto, couponTemplateExtRespDto);
                }
                if (couponTemplateExtRespDto.getHierarchy().equals(CouponHierarchyEnum.ORDER.getHierarchy())) {
                    if (orderAmount == null) {
                        return false;
                    }
                    if (!this.checkAmount((CouponExtRespDto)couponExtRespDto, couponTemplateExtRespDto)) {
                        this.logger.info("\u6821\u9a8c\u4f18\u60e0\u5238, \u8ba2\u5355\u7ea7\u4f18\u60e0\u5238\u91d1\u989d\u4e0d\u5339\u914d, couponCode={}, orderAmount={}", (Object)couponExtRespDto.getCouponCode(), (Object)orderAmount);
                        return false;
                    }
                }
                return true;
            }).collect(Collectors.toList());
            list.forEach(couponExtRespDto -> {
                CouponTemplateExtRespDto couponTemplateExtRespDto = (CouponTemplateExtRespDto)couponTemplateExtRespDtoMap.get(couponExtRespDto.getCouponTemplateId());
                couponExtRespDto.setCouponTemplate(couponTemplateExtRespDto);
            });
        }
        return list;
    }
}

