/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponCacheService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.CouponEo;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CouponCacheServiceImpl
implements ICouponCacheService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICacheService cacheService;

    @Override
    public String getMemberCouponCacheKey(Long memberId, String couponStatus) {
        return "CACHE:" + CouponEo.class.getName() + ":" + memberId + ":" + couponStatus;
    }

    public ICacheService getCacheService() {
        return this.cacheService;
    }

    public void setCacheService(ICacheService cacheService) {
        this.cacheService = cacheService;
    }

    @Override
    public void setMemberCouponCache(Long memberId, String couponStatus, List<CouponExtRespDto> list) {
        list = list == null ? Collections.emptyList() : list;
        String memberCouponCacheKey = this.getMemberCouponCacheKey(memberId, couponStatus);
        this.cacheService.setCache(memberCouponCacheKey, list, 3600);
    }

    @Override
    public List<CouponExtRespDto> findMemberCoupon(Long memberId, String couponStatus) {
        String memberCouponCacheKey = this.getMemberCouponCacheKey(memberId, couponStatus);
        List cacheList = (List)this.cacheService.getCache(memberCouponCacheKey, List.class);
        if (null == cacheList) {
            return null;
        }
        String json = JSON.toJSONString((Object)cacheList);
        return JSON.parseArray((String)json, CouponExtRespDto.class);
    }

    @Override
    public void deleteMemberCouponCache(Long memberId, String couponStatus) {
        String memberCouponCacheKey = this.getMemberCouponCacheKey(memberId, couponStatus);
        try {
            this.cacheService.delCache(memberCouponCacheKey);
        }
        catch (Exception e) {
            this.logger.error("\u6e05\u9664\u7528\u6237\u4f18\u60e0\u5238\u7f13\u5b58\u51fa\u73b0\u5f02\u5e38,memberId:{},couponStatus:{}", new Object[]{memberId, couponStatus, e});
        }
    }
}

