/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.impl.serializa;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common.CouponTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common.CouponUseTimeDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common.DynamicDate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponValidityTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.IDeserializationDynamicDate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.ISerializeCouPonUseTimeValue;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.impl.serializa.DeserializationFixDate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.impl.serializa.DeserializationForever;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class SerializeCouPonUseTimeValueDistribute
implements ApplicationListener<ApplicationStartedEvent> {
    private static Map<Integer, ISerializeCouPonUseTimeValue> SERIALIZE_MAP = new HashMap<Integer, ISerializeCouPonUseTimeValue>();
    private static Map<Integer, IDeserializationDynamicDate> DESERIALIZATION_MAP = new HashMap<Integer, IDeserializationDynamicDate>();
    private static DeserializationFixDate deserializationFixDate = new DeserializationFixDate();
    private static DeserializationForever deserializationForever = new DeserializationForever();

    public static void serialize(CouponTemplate couponTemplate) {
        CouponUseTimeDto couponUseTimeDto = couponTemplate.getCouponUseTimeReqDto();
        SERIALIZE_MAP.get(couponUseTimeDto.getType()).serialize(couponTemplate);
    }

    public static void deserialization(CouponTemplate couponTemplate) {
        if (couponTemplate.getValidityType() == CouponValidityTypeEnum.FIXED_DATE.getType()) {
            deserializationFixDate.deserialization(couponTemplate, null);
        } else if (couponTemplate.getValidityType() == CouponValidityTypeEnum.DYNAMIC_DATE.getType()) {
            DynamicDate dynamicDate = (DynamicDate)JSONObject.parseObject((String)couponTemplate.getDynamicDate(), DynamicDate.class);
            if (dynamicDate.getForever() != null && dynamicDate.getForever() == 1) {
                deserializationForever.deserialization(couponTemplate, dynamicDate);
            } else {
                IDeserializationDynamicDate deserializationDynamicDate = DESERIALIZATION_MAP.get(dynamicDate.getAfterDate());
                deserializationDynamicDate.deserialization(couponTemplate, dynamicDate);
            }
        }
    }

    public void onApplicationEvent(ApplicationStartedEvent applicationStartedEvent) {
        ConfigurableApplicationContext context = applicationStartedEvent.getApplicationContext();
        Map map = context.getBeansOfType(ISerializeCouPonUseTimeValue.class);
        map.keySet().stream().forEach(k -> {
            ISerializeCouPonUseTimeValue impl = (ISerializeCouPonUseTimeValue)map.get(k);
            SERIALIZE_MAP.put(impl.getType(), impl);
        });
        Map smap = context.getBeansOfType(IDeserializationDynamicDate.class);
        smap.keySet().stream().forEach(k -> {
            IDeserializationDynamicDate impl = (IDeserializationDynamicDate)smap.get(k);
            DESERIALIZATION_MAP.put(impl.getSupportAfterDay(), impl);
        });
    }
}

