/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.svr.rest.activity.base;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.RuleQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.RuleReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.RuleRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.IRuleApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IRuleQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IRuleService;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v2/rule"})
public class RuleRest
implements IRuleApi,
IRuleQueryApi {
    @Autowired
    private IRuleService ruleService;
    @Resource(name="ruleQueryImpl")
    private IRuleQueryApi iRuleQueryApi;

    public RestResponse<Long> addRule(@Valid @RequestBody RuleReqDto dto) {
        Long id = this.ruleService.addRule(dto);
        return new RestResponse((Object)id);
    }

    public RestResponse<String> modifyRule(@PathVariable(value="ruleId") long ruleId, @Valid @RequestBody RuleReqDto dto) {
        this.ruleService.modifyRule(ruleId, dto);
        return RestResponse.SUCCEED;
    }

    public RestResponse<String> deleteRule(@Min(value=1L, message="\u6d3b\u52a8\u6a21\u7248ID\u4e0d\u80fd\u5c0f\u4e8e1") @PathVariable(name="ruleId") @Min(value=1L, message="\u6d3b\u52a8\u6a21\u7248ID\u4e0d\u80fd\u5c0f\u4e8e1") Long ruleId) {
        this.ruleService.deleteRule(ruleId.longValue());
        return RestResponse.SUCCEED;
    }

    public RestResponse<String> enableRule(@Valid @Min(value=1L, message="\u68c0\u67e5\u70b9ID\u4e0d\u80fd\u5c0f\u4e8e1") @PathVariable(name="ruleId") @Valid @Min(value=1L, message="\u68c0\u67e5\u70b9ID\u4e0d\u80fd\u5c0f\u4e8e1") Long ruleId) {
        this.ruleService.enableRule(ruleId.longValue());
        return RestResponse.SUCCEED;
    }

    public RestResponse<String> disableRule(@Valid @Min(value=1L, message="\u68c0\u67e5\u70b9ID\u4e0d\u80fd\u5c0f\u4e8e1") @PathVariable(name="ruleId") @Valid @Min(value=1L, message="\u68c0\u67e5\u70b9ID\u4e0d\u80fd\u5c0f\u4e8e1") Long ruleId) {
        this.ruleService.disableRule(ruleId.longValue());
        return RestResponse.SUCCEED;
    }

    public RestResponse<RuleRespDto> queryRuleDetail(@PathVariable(value="id") @NotNull(message="ID\u4e0d\u5141\u8bb8\u4e3a\u7a7a") @NotNull(message="ID\u4e0d\u5141\u8bb8\u4e3a\u7a7a") Long id) {
        return this.iRuleQueryApi.queryRuleDetail(id);
    }

    public RestResponse<List<RuleRespDto>> queryRuleList(@Valid @SpringQueryMap RuleQueryReqDto reqDto) {
        return this.iRuleQueryApi.queryRuleList(reqDto);
    }

    public RestResponse<PageInfo<RuleRespDto>> queryRulePage(@Valid @SpringQueryMap RuleQueryReqDto reqDto, @RequestParam(value="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize) {
        return this.iRuleQueryApi.queryRulePage(reqDto, pageNum, pageSize);
    }
}

