/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.svr.rest.activity.base;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.CheckPointQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.CheckPointReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.CheckpointRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.ICheckPointApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.ICheckpointQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.ICheckPointService;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v2/check-point"})
@Api(tags={"\u8425\u9500\u4e2d\u5fc3\uff1a\u68c0\u67e5\u70b9\u7f16\u8f91API"})
public class CheckPointRest
implements ICheckPointApi,
ICheckpointQueryApi {
    @Autowired
    private ICheckPointService checkPointService;
    @Resource(name="checkpointQueryImpl")
    private ICheckpointQueryApi checkpointQueryApi;

    public RestResponse<Long> addCheckPoint(@Valid @RequestBody CheckPointReqDto dto) {
        long id = this.checkPointService.addCheckPoint(dto);
        return new RestResponse((Object)id);
    }

    public RestResponse<String> modifyCheckPoint(@Min(value=1L, message="\u52a8\u4f5c\u6a21\u677fID\u4e0d\u80fd\u5c0f\u4e8e1") @PathVariable(name="id") @Min(value=1L, message="\u52a8\u4f5c\u6a21\u677fID\u4e0d\u80fd\u5c0f\u4e8e1") Long id, @Valid @RequestBody CheckPointReqDto dto) {
        this.checkPointService.modifyCheckPoint(id, dto);
        return RestResponse.SUCCEED;
    }

    public RestResponse<String> deleteCheckPoint(@Valid @Min(value=1L, message="\u68c0\u67e5\u70b9ID\u4e0d\u80fd\u5c0f\u4e8e1") @PathVariable(name="cpId") @Valid @Min(value=1L, message="\u68c0\u67e5\u70b9ID\u4e0d\u80fd\u5c0f\u4e8e1") Long cpId) {
        this.checkPointService.deleteCheckPoint(cpId);
        return RestResponse.SUCCEED;
    }

    public RestResponse<String> enableCheckPoint(@Valid @Min(value=1L, message="\u68c0\u67e5\u70b9ID\u4e0d\u80fd\u5c0f\u4e8e1") @PathVariable(name="cpId") @Valid @Min(value=1L, message="\u68c0\u67e5\u70b9ID\u4e0d\u80fd\u5c0f\u4e8e1") Long cpId) {
        this.checkPointService.enableCheckPoint(cpId);
        return RestResponse.SUCCEED;
    }

    public RestResponse<String> disableCheckPoint(@Valid @Min(value=1L, message="\u68c0\u67e5\u70b9ID\u4e0d\u80fd\u5c0f\u4e8e1") @PathVariable(name="cpId") @Valid @Min(value=1L, message="\u68c0\u67e5\u70b9ID\u4e0d\u80fd\u5c0f\u4e8e1") Long cpId) {
        this.checkPointService.disableCheckPoint(cpId);
        return RestResponse.SUCCEED;
    }

    public RestResponse<CheckpointRespDto> queryCheckPointDetail(@NotNull(message="ID\u4e0d\u5141\u8bb8\u4e3a\u7a7a") @PathVariable(value="id") @NotNull(message="ID\u4e0d\u5141\u8bb8\u4e3a\u7a7a") Long id) {
        return this.checkpointQueryApi.queryCheckPointDetail(id);
    }

    public RestResponse<List<CheckpointRespDto>> queryCheckPointList(@SpringQueryMap @Valid CheckPointQueryReqDto checkPointQueryReqDto) {
        return this.checkpointQueryApi.queryCheckPointList(checkPointQueryReqDto);
    }

    public RestResponse<PageInfo<CheckpointRespDto>> queryCheckPointPage(@Valid @SpringQueryMap CheckPointQueryReqDto checkPointQueryReqDto, @RequestParam(value="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize) {
        return this.checkpointQueryApi.queryCheckPointPage(checkPointQueryReqDto, pageNum, pageSize);
    }
}

