/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.svr.rest.activity.base;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.PolicyQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.PolicyReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.PolicyRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.IPolicyApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IPolicyConfigQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IPolicyService;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v2/policy"})
public class PolicyConfigRest
implements IPolicyConfigQueryApi,
IPolicyApi {
    @Autowired
    private IPolicyService policyService;
    @Resource(name="policyApiImpl")
    private IPolicyApi policyApi;

    public RestResponse<List<PolicyRespDto>> queryPoliciesByCheckpoint(@PathVariable(name="checkpointCode") String checkpointCode) {
        return new RestResponse((Object)this.policyService.queryPoliciesByCp(checkpointCode));
    }

    public RestResponse<List<PolicyRespDto>> queryPoliciesByActIdAndCheckpoint(@PathVariable(name="activityId") Long activityId, @PathVariable(name="checkpointCode") String checkpointCode) {
        return new RestResponse((Object)this.policyService.queryPoliciesByAcAndCP(activityId, checkpointCode));
    }

    public RestResponse<List<ConditionRespDto>> queryConditionsByActivityId(@PathVariable(name="activityId") Long activityId) {
        return new RestResponse((Object)this.policyService.queryConditionsByActivityId(activityId));
    }

    public RestResponse<List<ActionRespDto>> queryActionsByActivityId(@PathVariable(name="activityId") Long activityId) {
        return new RestResponse((Object)this.policyService.queryActionsByActivityId(activityId));
    }

    public RestResponse<PolicyRespDto> queryPolicyDetail(@PathVariable(value="id") @NotNull(message="ID\u4e0d\u5141\u8bb8\u4e3a\u7a7a") @NotNull(message="ID\u4e0d\u5141\u8bb8\u4e3a\u7a7a") Long id) {
        return new RestResponse((Object)this.policyService.queryPolicyDetail(id));
    }

    public RestResponse<List<PolicyRespDto>> queryPolicyList(@Valid @SpringQueryMap PolicyQueryReqDto queryReqDto) {
        return new RestResponse((Object)this.policyService.queryPolicyList(queryReqDto));
    }

    public RestResponse<PageInfo<PolicyRespDto>> queryPolicyPage(@Valid @SpringQueryMap PolicyQueryReqDto queryReqDto, @RequestParam(value="pageNum", required=false, defaultValue="1") int pageNum, @RequestParam(value="pageSize", required=false, defaultValue="10") int pageSize) {
        return new RestResponse((Object)this.policyService.queryPolicyPage(queryReqDto, Integer.valueOf(pageNum), Integer.valueOf(pageSize)));
    }

    public RestResponse<Long> addPolicy(@RequestBody @Valid PolicyReqDto dto) {
        return this.policyApi.addPolicy(dto);
    }

    public RestResponse<String> modifyPolicy(@Min(value=1L, message="\u7b56\u7565\u4fe1\u606fID\u4e0d\u80fd\u5c0f\u4e8e1") @PathVariable(name="pId") @Min(value=1L, message="\u7b56\u7565\u4fe1\u606fID\u4e0d\u80fd\u5c0f\u4e8e1") Long tId, @RequestBody @Valid PolicyReqDto dto) {
        return this.policyApi.modifyPolicy(tId, dto);
    }

    public RestResponse<String> deletePolicy(@Min(value=1L, message="\u7b56\u7565\u4fe1\u606fID\u4e0d\u80fd\u5c0f\u4e8e1") @PathVariable(name="pId") @Min(value=1L, message="\u7b56\u7565\u4fe1\u606fID\u4e0d\u80fd\u5c0f\u4e8e1") Long tId) {
        return this.policyApi.deletePolicy(tId);
    }
}

