/*
 * @(#)IAuditDataApi.java 1.0 2018/9/3
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.shop.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shop.api.fallback.AuditDataFallBack;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;

/**
 * 待审核信息Api接口
 *
 * @author 华生
 * @since 1.0.0
 */
@FeignClient(contextId="src-main-com-dtyunxi-yundt-cube-center-shop-api-IAuditDataApi", name = "${yundt.cube.center.shop.api.name:yundt-cube-center-shop}", path = "/v2/audit/data", url = "${yundt.cube.center.shop.api:}",fallback = AuditDataFallBack.class)
public interface IAuditDataApi {


    /**
     * 删除审核信息
     *
     * @param auditDataId 区域ID
     * @return Void
     */
    @DeleteMapping(value = "/{auditDataId}", produces = "application/json")
    @ApiOperation(value = "删除审核信息", notes = "删除审核信息")
    RestResponse<Void> removeById(@PathVariable("auditDataId") Long auditDataId);
}
