package com.dtyunxi.yundt.cube.center.shop.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.freight.FreightTemplateReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.fallback.FreightTemplateFallBack;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 运费模板接口
 *
 * @author 本参
 * @since 3.14.1.0
 */
@FeignClient(contextId = "src-main-com-dtyunxi-yundt-cube-center-shop-api-IFreightTemplateApi", name = "${yundt.cube.center.shop.api.name:yundt-cube-center-shop}", path = "/v1/freight/template", url = "${yundt.cube.center.shop.api:}", fallback = FreightTemplateFallBack.class)

public interface IFreightTemplateApi {
    @PostMapping(value = "", produces = "application/json")
    @ApiOperation(value = "添加运费模板信息", notes = "添加运费模板信息")
    RestResponse<String> add(@RequestBody FreightTemplateReqDto freightTemplateReqDto);

    @PutMapping(value = "", produces = "application/json")
    @ApiOperation(value = "修改运费模板信息", notes = "修改运费模板信息")
    RestResponse<String> modify(@RequestBody FreightTemplateReqDto freightTemplateReqDto);

//    @PutMapping("/{templateId}/{state}")
//    @ApiOperation(value = "启用/禁用运费模板信息", notes = "启用/禁用运费模板信息")
//    RestResponse<Void> enable(@PathVariable("templateId") Long templateId, @PathVariable("state") Byte state);
//
//    @DeleteMapping("/{templateId}/")
//    @ApiOperation(value = "删除运费模板信息", notes = "删除运费模板信息")
//    RestResponse<Void> delete(@PathVariable("templateId") Long templateId);
}
