/*
 * @(#)ISellerApi.java 1.0 2018/9/4
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shop.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.*;
import com.dtyunxi.yundt.cube.center.shop.api.fallback.SellerFallBack;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 商户Api接口
 *
 * @author 华生
 * @since 1.0.0
 */
@FeignClient(contextId = "src-main-com-dtyunxi-yundt-cube-center-shop-api-ISellerApi", name = "${yundt.cube.center.shop.api.name:yundt-cube-center-shop}", path = "/v2/seller", url = "${yundt.cube.center.shop.api:}",fallback = SellerFallBack.class)
public interface ISellerApi {

    /**
     * 开通商户（新增店铺）
     *
     * @param sellerReqDto 开通商户信息封装对象
     * @param audit        是否需要审核
     * @return sellerId  商户ID
     */
    @PostMapping(value = "/addShop", produces = "application/json")
    @ApiOperation(value = "新增商户", notes = "开通商户 \t\n sellerReqDto:开通商户信息封装对象 \t\n audit:是否需要审核")
    RestResponse<Long> addSeller(@Valid @RequestBody SellerReqDto sellerReqDto,
                                 @RequestParam("audit") boolean audit);


    /**
     * 修改商户（修改商户）
     *
     * @param sellerReqDto 开通商户信息封装对象
     * @param needAudit    是否需要审核
     * @return void
     */
    @PutMapping(value = "", produces = "application/json")
    @ApiOperation(value = "修改商户", notes = "修改商户 \t\n sellerReqDto:修改商户信息封装对象 \t\n needAudit:是否需要审核")
    RestResponse<Void> modifySeller(@RequestBody SellerReqDto sellerReqDto,
                                    @RequestParam("needAudit") boolean needAudit);

    /**
     * 批量新增商户
     *
     * @param sellerReqDtos 商户信息
     * @param audit         是否需要审核
     * @return void
     */
    @PostMapping(value = "/batch")
    @ApiOperation(value = "批量新增商户", notes = "批量开通商户  \t\n sellerReqDtos:开通商户信息封装对象列表 \t\n audit:是否需要审核")
    RestResponse<Void> addSellers(@Valid @RequestBody List<SellerBatchReqDto> sellerReqDtos, @RequestParam("audit") boolean audit);

    /**
     * 绑定商户商户经营范围
     *
     * @param sellerBusinessScopeReqDto 商户经营范围请求Dto
     * @return sellerBusinessScopeId  商户经营范围ID
     */
    @PostMapping(value = "/business/scope")
    @ApiOperation(value = "绑定商户经营范围", notes = "绑定商户经营范围 \t\n sellerBusinessScopeReqDto:商户经营范围请求Dto")
    RestResponse<Long> addSellerBusinessScope(@Valid @RequestBody SellerBusinessScopeReqDto sellerBusinessScopeReqDto);


    /**
     * 修改商户经营区域（修改商户经营区域）
     *
     * @param sellerBusinessScopeReqDto 商户经营区请求域封装对象
     * @return void
     */
    @PutMapping(value = "/business/scope", produces = "application/json")
    @ApiOperation(value = "修改商户经营区域", notes = "修改商户经营区域 \t\n sellerBusinessScopeReqDto:商户经营范围请求Dto")
    RestResponse<Void> modifySellerBusinessScope(@RequestBody SellerBusinessScopeReqDto sellerBusinessScopeReqDto);


    /**
     * 根据主键ID删除商户经营区域
     *
     * @param id 主键ID
     * @return void
     */
    @DeleteMapping(value = "/business/{id}", produces = "application/json")
    @ApiOperation(value = "根据ID删除商户经营区域", notes = "根据ID删除商户经营区域 \t\n id:商户经营区域ID")
    RestResponse<Void> removeBusinessById(@NotNull(message = "ID不能为空") @PathVariable("id") Long id);


    /**
     * 根据所传的待审核信息审核商户
     *
     * @param status      审核状态(PENDING：待审核；PASS：审核通过；REFUSE：审核拒绝)
     * @param result      审核结果
     * @param auditPerson 审核人
     * @param tenantId    租户ID
     * @param auditId     待审核信息的ID
     * @return void
     */
    @PostMapping(value = "/audit/{auditId}", produces = "application/json")
    @ApiOperation(value = "根据所传待审核信息审核商户", notes = "根据所传待审核信息审核商户 \t\n auditId:待审核信息的ID \t\n tenantId:租户ID" +
            "\t\n status:审核状态(PENDING：待审核；PASS：审核通过；REFUSE：审核拒绝) \t\n result:审核结果 \t\n auditPerson:审核人")
    RestResponse<Void> auditSeller(
            @PathVariable("auditId") long auditId,
            @RequestParam("tenantId") long tenantId,
            @RequestParam("status") String status,
            @RequestParam("result") String result,
            @RequestParam("auditPerson") String auditPerson
    )
    ;


    /**
     * 根据ID删除店铺
     *
     * @param id 商户id
     * @return void
     */
    @DeleteMapping(value = "/{id}", produces = "application/json")
    @ApiOperation(value = "根据商户ID删除商户", notes = "根据商户ID删除商户 \t\n id:商户ID")
    RestResponse<Void> removeSellerById(
            @NotNull(message = "商户ID不能为空") @PathVariable("id") Long id
    );


    /**
     * 新增店铺经营区域
     *
     * @author wu.sheng
     * @date 2020/2/17 11:20
     */
    @PostMapping(value = "/area", produces = "application/json")
    @ApiOperation(value = "新增店铺经营区域", notes = "新增商户经营区域")
    RestResponse<Long> addSellerArea(@Valid @RequestBody SellerAreaDto sellerAreaDto);

    /**
     * 校验商户名称是否存在
     * @author weichu
     * @date 2021/3/16 13:10
     */
    @GetMapping(value = "/checkSellerName")
    @ApiOperation(value = "校验商户名称是否存在", notes = "校验商户名称是否存在")
    RestResponse<Boolean> checkSellerName(@RequestParam("sellerName")  String sellerName);


    @PostMapping(value = "/batch/update/seller/deadline", produces = "application/json")
    @ApiOperation(value = "批量更新商家认证截至时间", notes = "批量更新商家认证截至时间")
    RestResponse<Void> batchUpdateSellerDeadline(@RequestBody SellerCertificationDeadlineDto sellerCertificationDeadlineDto);
}
