/**
 * @(#)IShopAddressApi 1.0 2019/3/26
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shop.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopAddressReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.fallback.ShopAddressFallBack;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 地址管理Api接口
 *
 * @author shuangqing  2019/3/26
 */
@FeignClient(contextId="src-main-com-dtyunxi-yundt-cube-center-shop-api-IShopAddressApi", name = "${yundt.cube.center.shop.api.name:yundt-cube-center-shop}", path = "/v2/shop/address", url = "${yundt.cube.center.shop.api:}",fallback = ShopAddressFallBack.class)
public interface IShopAddressApi {

    @PostMapping(value = "", produces = "application/json")
    @ApiOperation(value = "新增店铺地址", notes = "新增店铺地址")
    RestResponse<Long> addShopAddress(@RequestBody ShopAddressReqDto shopAddressReqDto);


    @PutMapping(value = "", produces = "application/json")
    @ApiOperation(value = "根据id修改店铺地址", notes = "根据id修改店铺地址")
    RestResponse<Void> modifyShopAddress(@RequestBody ShopAddressReqDto shopAddressReqDto);

    @DeleteMapping(value = "/{id}", produces = "application/json")
    @ApiOperation(value = "根据id删除店铺地址", notes = "根据id删除店铺地址")
    RestResponse<Void> removeShopAddress(@PathVariable("id") Long id);
}
