/*
 * @(#)ISubStationApi.java 1.0 2020-06-01
 *
 * Copyright (c) 2017, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shop.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SubStationDto;
import com.dtyunxi.yundt.cube.center.shop.api.fallback.SubStationFallBack;
import io.swagger.annotations.ApiOperation;
import javax.validation.Valid;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 操作子站Api接口
 *
 * @author 东海
 * @since 1.0.0
 */
@FeignClient(contextId = "src-main-com-dtyunxi-yundt-cube-center-shop-api-ISubStationApi",
		     name = "${yundt.cube.center.shop.api.name:yundt-cube-center-shop}",
		     path = "/v2/sub-station",
		     url = "${yundt.cube.center.shop.api:}",fallback = SubStationFallBack.class)
public interface ISubStationApi {

	/**
	 * 新增子站
	 *
	 * @param subStationDto   子站Dto
	 * @return 子站ID
	 */
	@PostMapping(value = "", produces = "application/json")
	@ApiOperation(value = "新增子站", notes = "")
	RestResponse<Long> addSubStation(@Valid @RequestBody SubStationDto subStationDto);


	/**
	 * 根据主键id修改子站
	 *
	 * @param subStationDto   子站Dto
	 * @return void
	 */
	@PutMapping(value = "", produces = "application/json")
	@ApiOperation(value = "根据主键id修改子站", notes = "")
	RestResponse<Void> modifySubStation(@RequestBody SubStationDto subStationDto);
}
