package com.dtyunxi.yundt.cube.center.shop.api.agg;

import com.dtyunxi.rest.RestResponse;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;

@FeignClient(contextId = "src-main-com-dtyunxi-yundt-cube-center-shop-api-agg-IFreightAggApi",
        name = "${yundt.cube.center.shop.api.name:yundt-cube-center-shop}",
        path = "/v1/freight",
        url = "${yundt.cube.center.shop.api:}")
public interface IFreightAggApi {

    /**
     * 逻辑删除运费模板
     *
     * @param templateId 模板ID
     */
    @DeleteMapping("/{templateId}")
    @ApiOperation(value = "删除运费模板信息", notes = "删除运费模板信息")
    RestResponse<Void> deleteFreightTemplateById(@PathVariable("templateId") Long templateId);

    /**
     * 启用/禁用模板
     *
     * @param templateId 模板ID
     * @param state      0禁用 1启用
     */
    @PutMapping("/{templateId}/{state}")
    @ApiOperation(value = "启用/禁用运费模板信息", notes = "启用/禁用运费模板信息")
    RestResponse<Void> modifyTemplateStateById(@PathVariable("templateId") Long templateId, @PathVariable("state") Byte state);
}
