/**
 * @(#)IContext.java 1.0 2019年7月18日
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shop.api.agg;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shop.api.agg.bo.MerchantInfo;
import com.dtyunxi.yundt.cube.center.shop.api.agg.dto.request.MerchantQueryDto;
import com.dtyunxi.yundt.cube.center.shop.api.agg.dto.response.MerchantInfoRespDto;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;


/**
 * 商户服务</br>
 * 商户管理相关服务</br>
 * 1.商户开通</br>
 * 2.入驻申请与审核
 * 3.审核店铺
 * 4.查询商户列表
 * 5.修改商户信息
 * 6.查看商户信息
 *
 * @author malu
 * @time 2019年7月24日 上午10:21:18
 */
@FeignClient(contextId = "src-main-com-dtyunxi-yundt-cube-center-shop-api-agg-IMerchantAggApi",
        name = "${yundt.cube.center.shop.api.name:yundt-cube-center-shop}",
        path = "/v1/merchant",
        url = "${yundt.cube.center.shop.api:}")
public interface IMerchantAggApi {

    /**
     * 启用商户
     *
     * @param merchantId 商户id
     * @return
     */
    @PutMapping("/{merchantId}/enable")
    @ApiOperation(value = "启用商户")
    @ApiImplicitParam(paramType = "path", name = "merchantId", dataType = "Long", required = true, value = "商户id")
    RestResponse<Void> enable(@PathVariable("merchantId") Long merchantId);

    /**
     * 禁用商户
     *
     * @param merchantId 商户id
     * @return
     */
    @PutMapping("/{merchantId}/disable")
    @ApiOperation(value = "禁用商户")
    @ApiImplicitParam(paramType = "path", name = "merchantId", dataType = "Long", required = true, value = "商户id")
    RestResponse<Void> disable(@PathVariable("merchantId") Long merchantId);

    /**
     * 创建商户（运营平台）
     *
     * @param merchantInfo
     * @return
     */
    @PostMapping("")
    @ApiOperation(value = "创建商户")
    @ApiImplicitParam(paramType = "body", name = "merchantInfo", dataType = "MerchantInfo", required = true, value = "商户信息")
    RestResponse<Long> createMerchant(@Valid @RequestBody MerchantInfo merchantInfo);

    /**
     * 修改商户信息
     *
     * @param merchantId   商户id
     * @param merchantInfo 商户信息
     */
    @PutMapping("/{merchantId}")
    @ApiOperation(value = "修改商户")
    @ApiImplicitParams({
            @ApiImplicitParam(paramType = "path", name = "merchantId", dataType = "Long", required = true, value = "商户id"),
            @ApiImplicitParam(paramType = "body", name = "merchantInfo", dataType = "MerchantInfo", required = true, value = "商户信息")
    })
    RestResponse<Void> modify(@PathVariable("merchantId") Long merchantId, @RequestBody MerchantInfo merchantInfo);

    @GetMapping("")
    @ApiOperation(value = "查询商户信息列表")
    RestResponse<List<MerchantInfoRespDto>> querySellers(MerchantQueryDto merchantQueryDto);

}
