/**
 * @(#)IContext.java 1.0 2019年7月18日
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shop.api.agg;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shop.api.agg.bo.Shop;
import com.dtyunxi.yundt.cube.center.shop.api.agg.bo.ShopAudit;
import com.dtyunxi.yundt.cube.center.shop.api.agg.dto.request.ShopAggQueryDto;
import com.dtyunxi.yundt.cube.center.shop.api.agg.dto.response.ExportResultRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopQueryDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopTransportPartnerDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 店铺服务</br>
 * 店铺管理相关服务</br>
 * 1.店铺开通</br>
 * 2.店铺审核
 * 3.查看店铺
 * 4.查询店铺列表
 *
 * @author malu
 * @time 2019年7月24日 上午10:21:18
 */
@FeignClient(contextId = "src-main-com-dtyunxi-yundt-cube-center-shop-api-agg-IShopAggApi",
        name = "${yundt.cube.center.shop.api.name:yundt-cube-center-shop}",
        path = "/v1/shop",
        url = "${yundt.cube.center.shop.api:}")
public interface IShopAggApi {

    /**
     * 审核店铺
     *
     * @param shopAudit
     */
    @PutMapping("/audit")
    @ApiOperation(value = "审核店铺")
    @ApiImplicitParams({
            @ApiImplicitParam(paramType = "body", name = "shopAudit", dataType = "ShopAudit", required = true, value = "店铺审核bo")
    })
    RestResponse<Void> audit(@RequestBody ShopAudit shopAudit);

    /**
     * 启用店铺
     *
     * @param shopId
     */
    @PutMapping("/{shopId}/enable")
    @ApiOperation("启用店铺")
    @ApiImplicitParam(name = "shopId", paramType = "path", dataType = "Long", required = true, value = "店铺id")
    RestResponse<Void> enableShop(@PathVariable("shopId") Long shopId);

    /**
     * 禁用店铺
     *
     * @param shopId
     */
    @PutMapping("/{shopId}/disable")
    @ApiOperation("禁用店铺")
    @ApiImplicitParam(name = "shopId", paramType = "path", dataType = "Long", required = true, value = "店铺id")
    RestResponse<Void> disableShop(@PathVariable("shopId") Long shopId);

    /**
     * 分页查询店铺列表
     *
     * @param shopAggQueryDto
     * @param pageNum
     * @param pageSize
     * @return
     */
    @GetMapping("/page")
    @ApiOperation("分页查询店铺列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNum", paramType = "query", dataType = "Int", defaultValue = "1", required = true),
            @ApiImplicitParam(name = "pageSize", paramType = "query", dataType = "Int", defaultValue = "10", required = true)
    })
    RestResponse<PageInfo<Shop>> queryShopByPage(ShopAggQueryDto shopAggQueryDto,
                                                 @RequestParam(value = "pageNum", defaultValue = "1") Integer pageNum,
                                                 @RequestParam(value = "pageSize", defaultValue = "10") Integer pageSize);

    /**
     * 分页查询门店列表
     *
     * @param shopQueryDto
     * @param pageNum
     * @param pageSize
     * @return
     */
    @GetMapping("/storeShopList")
    @ApiOperation("分页查询店铺列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNum", paramType = "query", dataType = "Int", defaultValue = "1", required = true),
            @ApiImplicitParam(name = "pageSize", paramType = "query", dataType = "Int", defaultValue = "10", required = true)
    })
    RestResponse<PageInfo<Shop>> queryStoreShopList(ShopQueryDto shopQueryDto,
                                                    @RequestParam(value = "pageNum", defaultValue = "1") Integer pageNum,
                                                    @RequestParam(value = "pageSize", defaultValue = "10") Integer pageSize);


    /**
    * @Description: 检查地址是否在配送范围内
    * @Author: yan.haidong
    * @Param:
    * @Return:
    * @Date:  2020/7/17
    */
    @GetMapping("/isCheckAddress")
    @ApiOperation("检查地址是否在配送范围内(返回 1,表示不是o2o同城配送，2表示是o20且在配送范围内, 3表示是o20且不在配送范围内)")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "locationX", paramType = "query", dataType = "String", value = "经度"),
            @ApiImplicitParam(name = "locationY", paramType = "query", dataType = "String", value = "纬度"),
            @ApiImplicitParam(name = "shopIds", paramType = "query", dataType = "String", required = true, value = "店铺id,多个以逗号隔开")
    })
    RestResponse<Integer> isCheckAddress(@RequestParam(value = "locationX")String locationX,
                                         @RequestParam(value = "locationY")String locationY,
                                         @RequestParam(value = "shopIds")String shopIds);

    /**
     * 查询店铺ID查询店铺支持的配送方
     *
     * @param shopId
     * @return
     */
    @GetMapping("/{shopId}/partners")
    @ApiOperation(value = "查询店铺支持的配送方列表")
    RestResponse<List<ShopTransportPartnerDto>> queryShopTransportPartner(@PathVariable("shopId") Long shopId);

    /**
     * 店铺列表导出
     *
     * @param shopQueryDto
     * @return
     */
    @GetMapping("/exportShopList")
    @ApiOperation("导出店铺列表")
    RestResponse<ExportResultRespDto> exportShopList(ShopAggQueryDto shopQueryDto,
                                                     @RequestParam(value = "pageNum", defaultValue = "1") Integer pageNum,
                                                     @RequestParam(value = "pageSize", defaultValue = "10") Integer pageSize);
}
