/*
 * @(#)ISubStationService.java 1.0 2020-06-01
 *
 * Copyright (c) 2017, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shop.api.agg;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shop.api.agg.bo.SubStation;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SubStationQueryDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;

import javax.validation.Valid;

/**
* @Description:  子站服务
* @Author:
* @Param:
* @Return:
* @Date:  2020/6/1
*/
@FeignClient(contextId = "src-main-com-dtyunxi-yundt-cube-center-shop-api-agg-ISubStationAggApi",
		name = "${yundt.cube.center.shop.api.name:yundt-cube-center-shop}",
		path = "/v1/sub-station",
		url = "${yundt.cube.center.shop.api:}")
public interface ISubStationAggApi {

    /**
     * 分页查询子站列表
     *
     * @param subStationQueryDto
     * @param pageNum
     * @param pageSize
     * @return
	 */
	@GetMapping("/page")
	@ApiOperation("分页查询子站列表")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "pageNum",   paramType = "query", dataType = "Int", defaultValue = "1", required =  true),
			@ApiImplicitParam(name = "pageSize",  paramType = "query", dataType = "Int", defaultValue = "10", required = true)
	})
	RestResponse<PageInfo<SubStation>> querySubStationByPage(SubStationQueryDto subStationQueryDto, Integer pageNum, Integer pageSize);


    /**
     *根据ID查询子站实体
     *
     * @param id
     * @return com.dtyunxi.yundt.module.shop.bo.SubStation
     */
	@GetMapping("/{id}")
	@ApiOperation(value = "查看子站详情")
	@ApiImplicitParams({
			@ApiImplicitParam(paramType = "path", name = "id", dataType = "Long", required = true, value = "子站id")
	})
	RestResponse<SubStation> getById(Long id);

    /**
     * 创建子站
     *
     * @param subStation
     * @return java.lang.Long
     */
	@PostMapping("")
	@ApiOperation(value = "创建子站")
	@ApiImplicitParams({
			@ApiImplicitParam(paramType = "body",  name = "subStation", dataType = "SubStation", required = true, value = "子站bo")
	})
	RestResponse<Long> create(@Valid SubStation subStation);

	/**
	 * 修改子站
	 *
	 * @param subStation
	 * @return java.lang.Long
	 */
	@PutMapping("")
	@ApiOperation(value = "修改子站")
	@ApiImplicitParams({
			@ApiImplicitParam(paramType = "body", name = "subStation", dataType = "SubStation", required = true, value = "子站bo")
	})
	RestResponse<Long> modify(@Valid SubStation subStation);

	/**
	 *  启用子站
	 * * @param id
	 * @return void
	 */
	@PutMapping("/{id}/enable")
	@ApiOperation("启用子站")
	@ApiImplicitParam(name = "id", paramType = "path", dataType = "Long", required = true, value = "子站id")
	RestResponse<Void> enableShop(Long id);

	/**
	 *  禁用子站
	 * * @param id
	 * @return void
	 */
	@PutMapping("/{id}/disable")
	@ApiOperation("禁用子站")
	@ApiImplicitParam(name = "id", paramType = "path", dataType = "Long", required = true, value = "子站id")
	RestResponse<Void> disableShop(Long id);

    /**
     *  根据城市名称匹配区域子站
     *
     * @param city
     * @return com.dtyunxi.yundt.module.shop.bo.SubStation
     */
	@GetMapping("/match")
	@ApiOperation("根据城市名称匹配区域子站")
	RestResponse<SubStation> matchSubStation(String city);
}
